/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.madeaggregation;

import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.accounting.aggregator.plugin.Utility;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.documentstore.records.aggregation.AggregationUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregation {
    public static Logger logger = LoggerFactory.getLogger(Aggregation.class);
    protected int totalBufferedRecords;
    protected Map<String, List<AggregatedRecord<?, ?>>> bufferedRecords = new HashMap();

    protected static AggregatedRecord instantiateAggregatedRecord(Record record) throws Exception {
        String recordType = record.getRecordType();
        Class clz = RecordUtility.getAggregatedRecordClass((String)recordType);
        Class[] argTypes = new Class[]{record.getClass()};
        Constructor constructor = clz.getDeclaredConstructor(argTypes);
        Object[] arguments = new Object[]{record};
        return (AggregatedRecord)constructor.newInstance(arguments);
    }

    public static AggregatedRecord getAggregatedRecord(Record record) throws Exception {
        AggregatedRecord aggregatedRecord = record instanceof AggregatedRecord ? (AggregatedRecord)record : Aggregation.instantiateAggregatedRecord(record);
        return aggregatedRecord;
    }

    protected void madeAggregation(AggregatedRecord<?, ?> record) throws InvalidValueException {
        String recordType = record.getRecordType();
        if (this.bufferedRecords.containsKey(recordType)) {
            List<AggregatedRecord<?, ?>> records = this.bufferedRecords.get(recordType);
            boolean found = false;
            for (AggregatedRecord<?, ?> bufferedRecord : records) {
                AggregationUtility util;
                if (!(bufferedRecord instanceof AggregatedRecord) || !(util = new AggregationUtility(bufferedRecord)).isAggregable(record)) continue;
                try {
                    AggregatedRecord<?, ?> bufferedAggregatedRecord = bufferedRecord;
                    bufferedAggregatedRecord.aggregate(record);
                    bufferedAggregatedRecord.setCreationTime(record.getCreationTime());
                    found = true;
                    break;
                }
                catch (NotAggregatableRecordsExceptions e) {
                    logger.debug("{} is not usable for aggregation", bufferedRecord);
                }
            }
            if (!found) {
                records.add(record);
                ++this.totalBufferedRecords;
                return;
            }
        } else {
            ArrayList<Object> records = new ArrayList<Object>();
            try {
                records.add(Aggregation.getAggregatedRecord(record));
            }
            catch (Exception e) {
                logger.debug("pre Exception but records");
                records.add(record);
                logger.debug("Exception but records Add e:{}", (Throwable)e);
            }
            ++this.totalBufferedRecords;
            this.bufferedRecords.put(recordType, records);
        }
    }

    protected void clear() {
        this.totalBufferedRecords = 0;
        this.bufferedRecords.clear();
    }

    public List<JsonDocument> reallyFlush() throws Exception {
        if (this.totalBufferedRecords == 0) {
            return null;
        }
        ArrayList<JsonDocument> listDocumentToPersist = new ArrayList<JsonDocument>();
        Collection<List<AggregatedRecord<?, ?>>> collectionValuesRecord = this.bufferedRecords.values();
        for (List<AggregatedRecord<?, ?>> records : collectionValuesRecord) {
            for (Record record : records) {
                String id = record.getId();
                JsonObject accounting = JsonObject.empty();
                for (String key : record.getResourceProperties().keySet()) {
                    Object value = record.getResourceProperty(key);
                    if (!Utility.checkType(value)) {
                        value = value.toString();
                    }
                    accounting.put(key, value);
                }
                JsonDocument document = JsonDocument.create(id, accounting);
                listDocumentToPersist.add(document);
            }
        }
        this.clear();
        return listDocumentToPersist;
    }

    public void aggregate(AggregatedRecord<?, ?> record) throws Exception {
        if (record != null) {
            this.madeAggregation(record);
        }
    }
}

