/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.gcube.contentmanagement.blobstorage.service.operation.Copy;
import org.gcube.contentmanagement.blobstorage.service.operation.CopyDir;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.DownloadAndLock;
import org.gcube.contentmanagement.blobstorage.service.operation.GetFolderCount;
import org.gcube.contentmanagement.blobstorage.service.operation.GetFolderLastUpdate;
import org.gcube.contentmanagement.blobstorage.service.operation.GetFolderSize;
import org.gcube.contentmanagement.blobstorage.service.operation.GetHttpUrl;
import org.gcube.contentmanagement.blobstorage.service.operation.GetHttpsUrl;
import org.gcube.contentmanagement.blobstorage.service.operation.GetMetaFile;
import org.gcube.contentmanagement.blobstorage.service.operation.GetMetaInfo;
import org.gcube.contentmanagement.blobstorage.service.operation.GetRemotePath;
import org.gcube.contentmanagement.blobstorage.service.operation.GetSize;
import org.gcube.contentmanagement.blobstorage.service.operation.GetTTL;
import org.gcube.contentmanagement.blobstorage.service.operation.GetUrl;
import org.gcube.contentmanagement.blobstorage.service.operation.GetUserTotalItems;
import org.gcube.contentmanagement.blobstorage.service.operation.GetUserTotalVolume;
import org.gcube.contentmanagement.blobstorage.service.operation.Link;
import org.gcube.contentmanagement.blobstorage.service.operation.Lock;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Move;
import org.gcube.contentmanagement.blobstorage.service.operation.MoveDir;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.service.operation.Remove;
import org.gcube.contentmanagement.blobstorage.service.operation.RenewTTL;
import org.gcube.contentmanagement.blobstorage.service.operation.SetMetaInfo;
import org.gcube.contentmanagement.blobstorage.service.operation.Unlock;
import org.gcube.contentmanagement.blobstorage.service.operation.Upload;
import org.gcube.contentmanagement.blobstorage.service.operation.UploadAndUnlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationFactory {
    final Logger logger = LoggerFactory.getLogger(OperationFactory.class);
    String[] server;
    String bucket;
    String user;
    String password;
    Monitor monitor;
    boolean isChunk;
    private String backendType;

    public OperationFactory(String[] server, String user, String pwd, String bucket, Monitor monitor2, boolean isChunk, String backendType) {
        this.server = server;
        this.user = user;
        this.password = pwd;
        this.bucket = bucket;
        this.monitor = monitor2;
        this.isChunk = isChunk;
        this.backendType = backendType;
    }

    public Operation getOperation(String operation) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("getOperation(String) - start " + operation);
        }
        Operation op = null;
        if (operation.equalsIgnoreCase("upload")) {
            op = new Upload(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("download")) {
            op = new Download(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("remove")) {
            op = new Remove(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getSize")) {
            op = new GetSize(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getFolderSize")) {
            op = new GetFolderSize(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getFolderCount")) {
            op = new GetFolderCount(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getFolderLastUpdate")) {
            op = new GetFolderLastUpdate(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getTotalUserItems")) {
            op = new GetUserTotalItems(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getTotalUserVolume")) {
            op = new GetUserTotalVolume(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("download+lock")) {
            op = new DownloadAndLock(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("upload+unlock")) {
            op = new UploadAndUnlock(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("lock")) {
            op = new Lock(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("unlock")) {
            op = new Unlock(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getTTL")) {
            op = new GetTTL(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("renewTTL")) {
            op = new RenewTTL(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getUrl")) {
            op = new GetUrl(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getHttpUrl")) {
            op = new GetHttpUrl(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getHttpsUrl")) {
            op = new GetHttpsUrl(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("link")) {
            op = new Link(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("copy")) {
            op = new Copy(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("move")) {
            op = new Move(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("copy_dir")) {
            op = new CopyDir(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("move_dir")) {
            op = new MoveDir(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getMetaFile")) {
            op = new GetMetaFile(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getMetaInfo")) {
            op = new GetMetaInfo(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("setMetaInfo")) {
            op = new SetMetaInfo(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else if (operation.equalsIgnoreCase("getRemotePath")) {
            op = new GetRemotePath(this.server, this.user, this.password, this.bucket, this.monitor, this.isChunk, this.backendType);
        } else {
            this.logger.error("getOperation(String) - Invalid Operation");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getOperation(String) - end");
        }
        return op;
    }
}

