/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.handler.codec.memcache.binary;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.AbstractMemcacheObjectEncoder;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;

public abstract class AbstractBinaryMemcacheEncoder<M extends BinaryMemcacheMessage>
extends AbstractMemcacheObjectEncoder<M> {
    private static final int MINIMUM_HEADER_SIZE = 24;

    @Override
    protected ByteBuf encodeMessage(ChannelHandlerContext ctx, M msg) {
        ByteBuf buf = ctx.alloc().buffer(24 + msg.getExtrasLength() + msg.getKeyLength());
        this.encodeHeader(buf, msg);
        AbstractBinaryMemcacheEncoder.encodeExtras(buf, msg.getExtras());
        AbstractBinaryMemcacheEncoder.encodeKey(buf, msg.getKey());
        return buf;
    }

    private static void encodeExtras(ByteBuf buf, ByteBuf extras) {
        if (extras == null || !extras.isReadable()) {
            return;
        }
        buf.writeBytes(extras);
    }

    private static void encodeKey(ByteBuf buf, byte[] key) {
        if (key == null || key.length == 0) {
            return;
        }
        buf.writeBytes(key);
    }

    protected abstract void encodeHeader(ByteBuf var1, M var2);
}

