/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.config.easyconf;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.homelibrary.util.config.easyconf.ConfigurationException;
import org.gcube.common.homelibrary.util.config.easyconf.DatasourceURL;
import org.gcube.common.homelibrary.util.config.easyconf.FileConfigurationChangedReloadingStrategy;
import org.gcube.common.homelibrary.util.config.easyconf.JndiURL;

public class AggregatedProperties
extends CompositeConfiguration {
    private static final Log log = LogFactory.getLog(AggregatedProperties.class);
    private CompositeConfiguration baseConf = new CompositeConfiguration();
    private CompositeConfiguration globalConf = new CompositeConfiguration();
    private SystemConfiguration systemConfiguration = new SystemConfiguration();
    private Configuration prefixedSystemConfiguration = new SubsetConfiguration(this.systemConfiguration, this.getPrefix(), null);
    private String componentName;
    private String companyId;
    private List<String> loadedSources = new ArrayList<String>();
    private boolean baseConfigurationLoaded = false;

    public AggregatedProperties(String companyId, String componentName) {
        this.componentName = componentName;
        this.companyId = companyId;
    }

    @Override
    public Object getProperty(String key) {
        Object value = null;
        if (value == null) {
            value = System.getProperty(this.getPrefix() + key);
        }
        if (value == null) {
            value = this.globalConf.getProperty(this.getPrefix() + key);
        }
        if (value == null) {
            value = this.globalConf.getProperty(key);
        }
        if (value == null) {
            value = this.baseConf.getProperty(key);
        }
        if (value == null) {
            value = super.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        if (value == null && key.equals("easyconf:companyId")) {
            value = this.companyId;
        }
        if (value == null && key.equals("easyconf:componentName")) {
            value = this.componentName;
        }
        return value;
    }

    private String getPrefix() {
        return this.componentName + ":";
    }

    public void addBaseFileName(String fileName) {
        Configuration conf = this.addPropertiesSource(fileName, this.baseConf);
        if (conf != null && !conf.isEmpty()) {
            this.baseConfigurationLoaded = true;
        }
    }

    public void addGlobalFileName(String fileName) {
        this.addPropertiesSource(fileName, this.globalConf);
    }

    private Configuration addPropertiesSource(String sourceName, CompositeConfiguration loadedConf) {
        try {
            Configuration newConf = DatasourceURL.isDatasource(sourceName) ? this.addDatasourceProperties(sourceName) : (JndiURL.isJndi(sourceName) ? this.addJndiProperties(sourceName) : this.addFileProperties(sourceName, loadedConf));
            if (newConf != null) {
                loadedConf.addConfiguration(newConf);
                super.addConfiguration(newConf);
                if (newConf instanceof AbstractFileConfiguration) {
                    this.loadedSources.add(((AbstractFileConfiguration)newConf).getURL().toString());
                } else {
                    this.loadedSources.add(sourceName);
                }
            }
            return newConf;
        }
        catch (Exception ignore) {
            if (log.isDebugEnabled()) {
                log.debug("Configuration source " + sourceName + " ignored");
            }
            return null;
        }
    }

    private Configuration addFileProperties(String fileName, CompositeConfiguration loadedConf) throws ConfigurationException {
        try {
            PropertiesConfiguration newConf = new PropertiesConfiguration(fileName);
            URL fileURL = newConf.getURL();
            log.debug("Adding file: " + fileURL);
            Long delay = this.getReloadDelay(loadedConf, newConf);
            if (delay != null) {
                FileConfigurationChangedReloadingStrategy reloadingStrategy = new FileConfigurationChangedReloadingStrategy();
                if (log.isDebugEnabled()) {
                    log.debug("File " + fileURL + " will be reloaded every " + delay + " seconds");
                }
                long milliseconds = delay * 1000L;
                reloadingStrategy.setRefreshDelay(milliseconds);
                newConf.setReloadingStrategy(reloadingStrategy);
            }
            this.addIncludedPropertiesSources(newConf, loadedConf);
            return newConf;
        }
        catch (org.apache.commons.configuration.ConfigurationException e) {
            if (log.isDebugEnabled()) {
                log.debug("Configuration source " + fileName + " ignored");
            }
            return null;
        }
    }

    private Long getReloadDelay(CompositeConfiguration loadedConf, FileConfiguration newConf) {
        Long delay = newConf.getLong("easyconf:reload-delay", null);
        if (delay == null) {
            delay = loadedConf.getLong("easyconf:reload-delay", null);
        }
        return delay;
    }

    private Configuration addDatasourceProperties(String datasourcePath) {
        DatasourceURL dsUrl = new DatasourceURL(datasourcePath, this.companyId, this.componentName, "easyconf_properties");
        return dsUrl.getConfiguration();
    }

    private Configuration addJndiProperties(String sourcePath) {
        JndiURL jndiUrl = new JndiURL(sourcePath, this.companyId, this.componentName);
        return jndiUrl.getConfiguration();
    }

    private void addIncludedPropertiesSources(Configuration newConf, CompositeConfiguration loadedConf) {
        CompositeConfiguration tempConf = new CompositeConfiguration();
        tempConf.addConfiguration(this.prefixedSystemConfiguration);
        tempConf.addConfiguration(newConf);
        tempConf.addConfiguration(this.systemConfiguration);
        tempConf.addProperty("easyconf:companyId", this.companyId);
        tempConf.addProperty("easyconf:componentName", this.componentName);
        String[] fileNames = tempConf.getStringArray("include-and-override");
        for (int i = fileNames.length - 1; i >= 0; --i) {
            String iteratedFileName = fileNames[i];
            this.addPropertiesSource(iteratedFileName, loadedConf);
        }
    }

    public List<String> loadedSources() {
        return this.loadedSources;
    }

    public boolean hasBaseConfiguration() {
        return this.baseConfigurationLoaded;
    }

    public String getComponentName() {
        return this.componentName;
    }
}

