/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.util.internal;

import com.couchbase.client.deps.io.netty.util.internal.BaseLinkedQueue;
import com.couchbase.client.deps.io.netty.util.internal.LinkedQueueNode;
import com.couchbase.client.deps.io.netty.util.internal.MessagePassingQueue;

public class SpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    public SpscLinkedQueue() {
        this.spProducerNode(new LinkedQueueNode());
        this.spConsumerNode(this.producerNode);
        this.consumerNode.soNext(null);
    }

    @Override
    public boolean offer(E nextValue) {
        if (nextValue == null) {
            throw new IllegalArgumentException("null elements not allowed");
        }
        LinkedQueueNode<E> nextNode = new LinkedQueueNode<E>(nextValue);
        this.producerNode.soNext(nextNode);
        this.producerNode = nextNode;
        return true;
    }

    @Override
    public E poll() {
        LinkedQueueNode nextNode = this.consumerNode.lvNext();
        if (nextNode != null) {
            Object nextValue = nextNode.getAndNullValue();
            this.consumerNode = nextNode;
            return nextValue;
        }
        return null;
    }

    @Override
    public E peek() {
        LinkedQueueNode nextNode = this.consumerNode.lvNext();
        if (nextNode != null) {
            return nextNode.lpValue();
        }
        return null;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        int drained;
        long result = 0L;
        while ((drained = this.drain(c, 4096)) == 4096 && (result += (long)drained) <= 0x7FFFEFFFL) {
        }
        return (int)result;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        long result = 0L;
        do {
            this.fill(s, 4096);
        } while ((result += 4096L) <= 0x7FFFEFFFL);
        return (int)result;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        LinkedQueueNode chaserNode = this.consumerNode;
        for (int i = 0; i < limit; ++i) {
            if ((chaserNode = chaserNode.lvNext()) == null) {
                return i;
            }
            Object nextValue = chaserNode.getAndNullValue();
            this.consumerNode = chaserNode;
            c.accept(nextValue);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        LinkedQueueNode<E> chaserNode = this.producerNode;
        for (int i = 0; i < limit; ++i) {
            LinkedQueueNode<E> nextNode = new LinkedQueueNode<E>(s.get());
            chaserNode.soNext(nextNode);
            this.producerNode = chaserNode = nextNode;
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        LinkedQueueNode chaserNode = this.consumerNode;
        int idleCounter = 0;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                LinkedQueueNode next = chaserNode.lvNext();
                if (next == null) {
                    idleCounter = wait.idle(idleCounter);
                    continue;
                }
                chaserNode = next;
                idleCounter = 0;
                Object nextValue = chaserNode.getAndNullValue();
                this.consumerNode = chaserNode;
                c.accept(nextValue);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        LinkedQueueNode<E> chaserNode = this.producerNode;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                LinkedQueueNode<E> nextNode = new LinkedQueueNode<E>(s.get());
                chaserNode.soNext(nextNode);
                this.producerNode = chaserNode = nextNode;
            }
        }
    }
}

