/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.error.subdoc;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.java.error.subdoc.SubDocumentException;
import com.couchbase.client.java.subdoc.MutationSpec;
import java.util.List;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class MultiMutationException
extends SubDocumentException {
    private final int index;
    private final ResponseStatus status;
    private final List<MutationSpec> originalSpec;

    public MultiMutationException(int index, ResponseStatus errorStatus, List<MutationSpec> originalSpec, CouchbaseException errorException) {
        super("Multiple mutation could not be applied. First problematic failure at " + index + " with status " + (Object)((Object)errorStatus), errorException);
        this.index = index;
        this.status = errorStatus;
        this.originalSpec = originalSpec;
    }

    public int firstFailureIndex() {
        return this.index;
    }

    public ResponseStatus firstFailureStatus() {
        return this.status;
    }

    public List<MutationSpec> originalSpec() {
        return this.originalSpec;
    }

    public MutationSpec firstFailureSpec() {
        return this.originalSpec.get(this.index);
    }
}

