/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.annotations.Experimental;
import rx.exceptions.OnErrorNotImplementedException;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Actions;
import rx.functions.Func1;
import rx.internal.operators.BlockingOperatorLatest;
import rx.internal.operators.BlockingOperatorMostRecent;
import rx.internal.operators.BlockingOperatorNext;
import rx.internal.operators.BlockingOperatorToFuture;
import rx.internal.operators.BlockingOperatorToIterator;
import rx.internal.operators.NotificationLite;
import rx.internal.util.BlockingUtils;
import rx.internal.util.UtilityFunctions;
import rx.subscriptions.Subscriptions;

public final class BlockingObservable<T> {
    private final Observable<? extends T> o;
    private static final Object ON_START = new Object();
    private static final Object SET_PRODUCER = new Object();
    private static final Object UNSUBSCRIBE = new Object();

    private BlockingObservable(Observable<? extends T> o) {
        this.o = o;
    }

    public static <T> BlockingObservable<T> from(Observable<? extends T> o) {
        return new BlockingObservable<T>(o);
    }

    public void forEach(final Action1<? super T> onNext) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exceptionFromOnError = new AtomicReference();
        Subscription subscription = this.o.subscribe(new Subscriber<T>(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onError(Throwable e) {
                exceptionFromOnError.set(e);
                latch.countDown();
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
        BlockingUtils.awaitForComplete(latch, subscription);
        if (exceptionFromOnError.get() != null) {
            if (exceptionFromOnError.get() instanceof RuntimeException) {
                throw (RuntimeException)exceptionFromOnError.get();
            }
            throw new RuntimeException((Throwable)exceptionFromOnError.get());
        }
    }

    public Iterator<T> getIterator() {
        return BlockingOperatorToIterator.toIterator(this.o);
    }

    public T first() {
        return this.blockForSingle(this.o.first());
    }

    public T first(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.first(predicate));
    }

    public T firstOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).firstOrDefault(defaultValue));
    }

    public T firstOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).firstOrDefault(defaultValue));
    }

    public T last() {
        return this.blockForSingle(this.o.last());
    }

    public T last(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.last(predicate));
    }

    public T lastOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).lastOrDefault(defaultValue));
    }

    public T lastOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).lastOrDefault(defaultValue));
    }

    public Iterable<T> mostRecent(T initialValue) {
        return BlockingOperatorMostRecent.mostRecent(this.o, initialValue);
    }

    public Iterable<T> next() {
        return BlockingOperatorNext.next(this.o);
    }

    public Iterable<T> latest() {
        return BlockingOperatorLatest.latest(this.o);
    }

    public T single() {
        return this.blockForSingle(this.o.single());
    }

    public T single(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.single(predicate));
    }

    public T singleOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).singleOrDefault(defaultValue));
    }

    public T singleOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).singleOrDefault(defaultValue));
    }

    public Future<T> toFuture() {
        return BlockingOperatorToFuture.toFuture(this.o);
    }

    public Iterable<T> toIterable() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return BlockingObservable.this.getIterator();
            }
        };
    }

    private T blockForSingle(Observable<? extends T> observable) {
        final AtomicReference returnItem = new AtomicReference();
        final AtomicReference returnException = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Subscription subscription = observable.subscribe(new Subscriber<T>(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onError(Throwable e) {
                returnException.set(e);
                latch.countDown();
            }

            @Override
            public void onNext(T item) {
                returnItem.set(item);
            }
        });
        BlockingUtils.awaitForComplete(latch, subscription);
        if (returnException.get() != null) {
            if (returnException.get() instanceof RuntimeException) {
                throw (RuntimeException)returnException.get();
            }
            throw new RuntimeException((Throwable)returnException.get());
        }
        return (T)returnItem.get();
    }

    @Experimental
    public void subscribe() {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] error = new Throwable[]{null};
        Subscription s = this.o.subscribe(new Subscriber<T>(){

            @Override
            public void onNext(T t) {
            }

            @Override
            public void onError(Throwable e) {
                error[0] = e;
                cdl.countDown();
            }

            @Override
            public void onCompleted() {
                cdl.countDown();
            }
        });
        BlockingUtils.awaitForComplete(cdl, s);
        Throwable e = error[0];
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Experimental
    public void subscribe(Observer<? super T> observer) {
        final NotificationLite<T> nl = NotificationLite.instance();
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Subscription s = this.o.subscribe(new Subscriber<T>(){

            @Override
            public void onNext(T t) {
                queue.offer(nl.next(t));
            }

            @Override
            public void onError(Throwable e) {
                queue.offer(nl.error(e));
            }

            @Override
            public void onCompleted() {
                queue.offer(nl.completed());
            }
        });
        try {
            while (true) {
                Object o;
                if ((o = queue.poll()) == null) {
                    o = queue.take();
                }
                if (nl.accept(observer, o)) {
                    return;
                }
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            observer.onError(e);
            return;
        }
        finally {
            s.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Experimental
    public void subscribe(Subscriber<? super T> subscriber) {
        final NotificationLite<? super T> nl = NotificationLite.instance();
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        final Producer[] theProducer = new Producer[]{null};
        Subscriber s = new Subscriber<T>(){

            @Override
            public void onNext(T t) {
                queue.offer(nl.next(t));
            }

            @Override
            public void onError(Throwable e) {
                queue.offer(nl.error(e));
            }

            @Override
            public void onCompleted() {
                queue.offer(nl.completed());
            }

            @Override
            public void setProducer(Producer p) {
                theProducer[0] = p;
                queue.offer(SET_PRODUCER);
            }

            @Override
            public void onStart() {
                queue.offer(ON_START);
            }
        };
        subscriber.add(s);
        subscriber.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                queue.offer(UNSUBSCRIBE);
            }
        }));
        this.o.subscribe(s);
        try {
            while (!subscriber.isUnsubscribed()) {
                Object o = queue.poll();
                if (o == null) {
                    o = queue.take();
                }
                if (subscriber.isUnsubscribed()) break;
                if (o == UNSUBSCRIBE) {
                    break;
                }
                if (o == ON_START) {
                    subscriber.onStart();
                    continue;
                }
                if (o == SET_PRODUCER) {
                    subscriber.setProducer(theProducer[0]);
                    continue;
                }
                if (!nl.accept(subscriber, o)) continue;
                return;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            subscriber.onError(e);
        }
        finally {
            s.unsubscribe();
        }
    }

    @Experimental
    public void subscribe(Action1<? super T> onNext) {
        this.subscribe(onNext, (Action1<Throwable>)new Action1<Throwable>(){

            @Override
            public void call(Throwable t) {
                throw new OnErrorNotImplementedException(t);
            }
        }, Actions.empty());
    }

    @Experimental
    public void subscribe(Action1<? super T> onNext, Action1<? super Throwable> onError) {
        this.subscribe(onNext, onError, Actions.empty());
    }

    @Experimental
    public void subscribe(final Action1<? super T> onNext, final Action1<? super Throwable> onError, final Action0 onCompleted) {
        this.subscribe(new Observer<T>(){

            @Override
            public void onNext(T t) {
                onNext.call(t);
            }

            @Override
            public void onError(Throwable e) {
                onError.call(e);
            }

            @Override
            public void onCompleted() {
                onCompleted.call();
            }
        });
    }
}

