/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.env;

import com.couchbase.client.core.env.DefaultCoreEnvironment;
import com.couchbase.client.core.env.resources.ShutdownHook;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.consumers.LoggingConsumer;
import com.couchbase.client.core.logging.CouchbaseLogLevel;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.metrics.LatencyMetricsCollectorConfig;
import com.couchbase.client.core.metrics.MetricsCollectorConfig;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;

public class DefaultCouchbaseEnvironment
extends DefaultCoreEnvironment
implements CouchbaseEnvironment {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseEnvironment.class);
    private static final long MANAGEMENT_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long QUERY_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long VIEW_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long SEARCH_TIMEOUT = TimeUnit.SECONDS.toMillis(75L);
    private static final long KV_TIMEOUT = 2500L;
    private static final long CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long DISCONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(25L);
    private static final boolean DNS_SRV_ENABLED = false;
    private final long managementTimeout;
    private final long queryTimeout;
    private final long viewTimeout;
    private final long searchTimeout;
    private final long kvTimeout;
    private final long connectTimeout;
    private final long disconnectTimeout;
    private final boolean dnsSrvEnabled;
    protected static String CLIENT_VERSION;
    protected static String CLIENT_GIT_VERSION;
    public static String SDK_PACKAGE_NAME_AND_VERSION;
    public static String SDK_USER_AGENT;
    private static final String VERSION_PROPERTIES = "com.couchbase.client.java.properties";

    private DefaultCouchbaseEnvironment(Builder builder) {
        super(builder);
        this.managementTimeout = DefaultCouchbaseEnvironment.longPropertyOr("managementTimeout", builder.managementTimeout);
        this.queryTimeout = DefaultCouchbaseEnvironment.longPropertyOr("queryTimeout", builder.queryTimeout);
        this.viewTimeout = DefaultCouchbaseEnvironment.longPropertyOr("viewTimeout", builder.viewTimeout);
        this.kvTimeout = DefaultCouchbaseEnvironment.longPropertyOr("kvTimeout", builder.kvTimeout);
        this.searchTimeout = DefaultCouchbaseEnvironment.longPropertyOr("searchTimeout", builder.searchTimeout);
        this.connectTimeout = DefaultCouchbaseEnvironment.longPropertyOr("connectTimeout", builder.connectTimeout);
        this.disconnectTimeout = DefaultCouchbaseEnvironment.longPropertyOr("disconnectTimeout", builder.disconnectTimeout);
        this.dnsSrvEnabled = this.booleanPropertyOr("dnsSrvEnabled", builder.dnsSrvEnabled);
        if (this.queryTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured query timeout is greater than the maximum request lifetime. This can lead to falsely cancelled requests.");
        }
        if (this.kvTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured key/value timeout is greater than the maximum request lifetime.This can lead to falsely cancelled requests.");
        }
        if (this.viewTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured view timeout is greater than the maximum request lifetime.This can lead to falsely cancelled requests.");
        }
        if (this.managementTimeout > this.maxRequestLifetime()) {
            LOGGER.warn("The configured management timeout is greater than the maximum request lifetime.This can lead to falsely cancelled requests.");
        }
    }

    public static DefaultCouchbaseEnvironment create() {
        return DefaultCouchbaseEnvironment.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public long managementTimeout() {
        return this.managementTimeout;
    }

    @Override
    public long queryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public long viewTimeout() {
        return this.viewTimeout;
    }

    @Override
    public long searchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public long kvTimeout() {
        return this.kvTimeout;
    }

    @Override
    public long connectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public long disconnectTimeout() {
        return this.disconnectTimeout;
    }

    @Override
    public boolean dnsSrvEnabled() {
        return this.dnsSrvEnabled;
    }

    @Override
    public String clientVersion() {
        return CLIENT_VERSION;
    }

    @Override
    public String clientBuild() {
        return CLIENT_GIT_VERSION;
    }

    @Override
    protected StringBuilder dumpParameters(StringBuilder sb) {
        super.dumpParameters(sb);
        sb.append(", queryTimeout=").append(this.queryTimeout);
        sb.append(", viewTimeout=").append(this.viewTimeout);
        sb.append(", kvTimeout=").append(this.kvTimeout);
        sb.append(", connectTimeout=").append(this.connectTimeout);
        sb.append(", disconnectTimeout=").append(this.disconnectTimeout);
        sb.append(", dnsSrvEnabled=").append(this.dnsSrvEnabled);
        return sb;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CouchbaseEnvironment: {");
        this.dumpParameters(sb).append('}');
        return sb.toString();
    }

    static /* synthetic */ long access$800() {
        return MANAGEMENT_TIMEOUT;
    }

    static /* synthetic */ long access$900() {
        return QUERY_TIMEOUT;
    }

    static /* synthetic */ long access$1000() {
        return VIEW_TIMEOUT;
    }

    static /* synthetic */ long access$1100() {
        return SEARCH_TIMEOUT;
    }

    static /* synthetic */ long access$1200() {
        return CONNECT_TIMEOUT;
    }

    static /* synthetic */ long access$1300() {
        return DISCONNECT_TIMEOUT;
    }

    static {
        SDK_USER_AGENT = SDK_PACKAGE_NAME_AND_VERSION = "couchbase-java-client";
        try {
            Class<CouchbaseCluster> facadeClass = CouchbaseCluster.class;
            if (facadeClass == null) {
                throw new IllegalStateException("Could not locate ClusterFacade");
            }
            String version = null;
            String gitVersion = null;
            try {
                Properties versionProp = new Properties();
                versionProp.load(DefaultCouchbaseEnvironment.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES));
                version = versionProp.getProperty("specificationVersion");
                gitVersion = versionProp.getProperty("implementationVersion");
            }
            catch (Exception e) {
                LOGGER.info("Could not retrieve java-client version properties, defaulting.", e);
            }
            CLIENT_VERSION = version == null ? "unknown" : version;
            CLIENT_GIT_VERSION = gitVersion == null ? "unknown" : gitVersion;
            SDK_PACKAGE_NAME_AND_VERSION = String.format("couchbase-java-client/%s (git: %s, core: %s)", CLIENT_VERSION, CLIENT_GIT_VERSION, CORE_GIT_VERSION);
            SDK_USER_AGENT = String.format("%s (%s/%s %s; %s %s)", SDK_PACKAGE_NAME_AND_VERSION, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.vm.name"), System.getProperty("java.runtime.version"));
        }
        catch (Exception ex) {
            LOGGER.info("Could not set up user agent and packages, defaulting.", ex);
        }
    }

    public static class Builder
    extends DefaultCoreEnvironment.Builder {
        private long managementTimeout = DefaultCouchbaseEnvironment.access$800();
        private long queryTimeout = DefaultCouchbaseEnvironment.access$900();
        private long viewTimeout = DefaultCouchbaseEnvironment.access$1000();
        private long kvTimeout = 2500L;
        private long searchTimeout = DefaultCouchbaseEnvironment.access$1100();
        private long connectTimeout = DefaultCouchbaseEnvironment.access$1200();
        private long disconnectTimeout = DefaultCouchbaseEnvironment.access$1300();
        private boolean dnsSrvEnabled = false;

        public Builder() {
            this.packageNameAndVersion(SDK_PACKAGE_NAME_AND_VERSION);
            this.userAgent(SDK_USER_AGENT);
        }

        public Builder managementTimeout(long managementTimeout) {
            this.managementTimeout = managementTimeout;
            return this;
        }

        public Builder queryTimeout(long queryTimeout) {
            this.queryTimeout = queryTimeout;
            return this;
        }

        public Builder viewTimeout(long viewTimeout) {
            this.viewTimeout = viewTimeout;
            return this;
        }

        public Builder kvTimeout(long kvTimeout) {
            this.kvTimeout = kvTimeout;
            return this;
        }

        public Builder searchTimeout(long searchTimeout) {
            this.searchTimeout = searchTimeout;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder disconnectTimeout(long disconnectTimeout) {
            this.disconnectTimeout = disconnectTimeout;
            return this;
        }

        @Override
        public Builder sslEnabled(boolean sslEnabled) {
            super.sslEnabled(sslEnabled);
            return this;
        }

        @Override
        public Builder sslKeystoreFile(String sslKeystoreFile) {
            super.sslKeystoreFile(sslKeystoreFile);
            return this;
        }

        @Override
        public Builder sslKeystorePassword(String sslKeystorePassword) {
            super.sslKeystorePassword(sslKeystorePassword);
            return this;
        }

        @Override
        public Builder queryEnabled(boolean queryEnabled) {
            super.queryEnabled(queryEnabled);
            return this;
        }

        @Override
        public Builder queryPort(int queryPort) {
            super.queryPort(queryPort);
            return this;
        }

        @Override
        public Builder bootstrapHttpEnabled(boolean bootstrapHttpEnabled) {
            super.bootstrapHttpEnabled(bootstrapHttpEnabled);
            return this;
        }

        @Override
        public Builder bootstrapCarrierEnabled(boolean bootstrapCarrierEnabled) {
            super.bootstrapCarrierEnabled(bootstrapCarrierEnabled);
            return this;
        }

        @Override
        public Builder bootstrapHttpDirectPort(int bootstrapHttpDirectPort) {
            super.bootstrapHttpDirectPort(bootstrapHttpDirectPort);
            return this;
        }

        @Override
        public Builder bootstrapHttpSslPort(int bootstrapHttpSslPort) {
            super.bootstrapHttpSslPort(bootstrapHttpSslPort);
            return this;
        }

        @Override
        public Builder bootstrapCarrierDirectPort(int bootstrapCarrierDirectPort) {
            super.bootstrapCarrierDirectPort(bootstrapCarrierDirectPort);
            return this;
        }

        @Override
        public Builder bootstrapCarrierSslPort(int bootstrapCarrierSslPort) {
            super.bootstrapCarrierSslPort(bootstrapCarrierSslPort);
            return this;
        }

        @Override
        public Builder ioPoolSize(int ioPoolSize) {
            super.ioPoolSize(ioPoolSize);
            return this;
        }

        @Override
        public Builder computationPoolSize(int computationPoolSize) {
            super.computationPoolSize(computationPoolSize);
            return this;
        }

        @Override
        public Builder requestBufferSize(int requestBufferSize) {
            super.requestBufferSize(requestBufferSize);
            return this;
        }

        @Override
        public Builder responseBufferSize(int responseBufferSize) {
            super.responseBufferSize(responseBufferSize);
            return this;
        }

        @Override
        public Builder kvEndpoints(int kvEndpoints) {
            super.kvEndpoints(kvEndpoints);
            return this;
        }

        @Override
        public Builder viewEndpoints(int viewServiceEndpoints) {
            super.viewEndpoints(viewServiceEndpoints);
            return this;
        }

        @Override
        public Builder queryEndpoints(int queryServiceEndpoints) {
            super.queryEndpoints(queryServiceEndpoints);
            return this;
        }

        @Override
        public Builder ioPool(EventLoopGroup group) {
            super.ioPool(group);
            return this;
        }

        @Override
        public Builder ioPool(EventLoopGroup group, ShutdownHook shutdownHook) {
            super.ioPool(group, shutdownHook);
            return this;
        }

        @Override
        public Builder scheduler(Scheduler scheduler) {
            super.scheduler(scheduler);
            return this;
        }

        @Override
        public Builder scheduler(Scheduler scheduler, ShutdownHook shutdownHook) {
            super.scheduler(scheduler, shutdownHook);
            return this;
        }

        @Override
        public Builder observeIntervalDelay(Delay observeIntervalDelay) {
            super.observeIntervalDelay(observeIntervalDelay);
            return this;
        }

        @Override
        public Builder reconnectDelay(Delay reconnectDelay) {
            super.reconnectDelay(reconnectDelay);
            return this;
        }

        @Override
        public Builder dcpEnabled(boolean dcpEnabled) {
            super.dcpEnabled(dcpEnabled);
            return this;
        }

        @Override
        public Builder retryDelay(Delay retryDelay) {
            super.retryDelay(retryDelay);
            return this;
        }

        @Override
        public Builder retryStrategy(RetryStrategy retryStrategy) {
            super.retryStrategy(retryStrategy);
            return this;
        }

        @Override
        public Builder maxRequestLifetime(long maxRequestLifetime) {
            super.maxRequestLifetime(maxRequestLifetime);
            return this;
        }

        @Override
        public Builder keepAliveInterval(long keepAliveIntervalMilliseconds) {
            super.keepAliveInterval(keepAliveIntervalMilliseconds);
            return this;
        }

        @Override
        public Builder autoreleaseAfter(long autoreleaseAfter) {
            super.autoreleaseAfter(autoreleaseAfter);
            return this;
        }

        @Override
        public Builder eventBus(EventBus eventBus) {
            super.eventBus(eventBus);
            return this;
        }

        @Override
        public Builder bufferPoolingEnabled(boolean bufferPoolingEnabled) {
            super.bufferPoolingEnabled(bufferPoolingEnabled);
            return this;
        }

        @Override
        public Builder packageNameAndVersion(String packageNameAndVersion) {
            super.packageNameAndVersion(packageNameAndVersion);
            return this;
        }

        @Override
        public Builder userAgent(String userAgent) {
            super.userAgent(userAgent);
            return this;
        }

        public Builder dnsSrvEnabled(boolean dnsSrvEnabled) {
            this.dnsSrvEnabled = dnsSrvEnabled;
            return this;
        }

        @Override
        public Builder mutationTokensEnabled(boolean mutationTokensEnabled) {
            super.mutationTokensEnabled(mutationTokensEnabled);
            return this;
        }

        @Override
        public Builder tcpNodelayEnabled(boolean tcpNodelayEnabled) {
            super.tcpNodelayEnabled(tcpNodelayEnabled);
            return this;
        }

        @Override
        public Builder runtimeMetricsCollectorConfig(MetricsCollectorConfig metricsCollectorConfig) {
            super.runtimeMetricsCollectorConfig(metricsCollectorConfig);
            return this;
        }

        @Override
        public Builder networkLatencyMetricsCollectorConfig(LatencyMetricsCollectorConfig metricsCollectorConfig) {
            super.networkLatencyMetricsCollectorConfig(metricsCollectorConfig);
            return this;
        }

        @Override
        public Builder defaultMetricsLoggingConsumer(boolean enabled, CouchbaseLogLevel level, LoggingConsumer.OutputFormat format) {
            super.defaultMetricsLoggingConsumer(enabled, level, format);
            return this;
        }

        @Override
        public Builder defaultMetricsLoggingConsumer(boolean enabled, CouchbaseLogLevel level) {
            super.defaultMetricsLoggingConsumer(enabled, level);
            return this;
        }

        @Override
        public Builder dcpConnectionBufferSize(int dcpConnectionBufferSize) {
            super.dcpConnectionBufferSize(dcpConnectionBufferSize);
            return this;
        }

        @Override
        public Builder dcpConnectionBufferAckThreshold(double dcpConnectionBufferAckThreshold) {
            super.dcpConnectionBufferAckThreshold(dcpConnectionBufferAckThreshold);
            return this;
        }

        @Override
        public Builder socketConnectTimeout(int socketConnectTimeout) {
            super.socketConnectTimeout(socketConnectTimeout);
            return this;
        }

        @Override
        public Builder callbacksOnIoPool(boolean callbacksOnIoPool) {
            super.callbacksOnIoPool(callbacksOnIoPool);
            return this;
        }

        @Override
        public Builder searchEndpoints(int searchEndpoints) {
            super.searchEndpoints(searchEndpoints);
            return this;
        }

        @Override
        public DefaultCouchbaseEnvironment build() {
            return new DefaultCouchbaseEnvironment(this);
        }
    }
}

