/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;
import rx.internal.producers.ProducerArbiter;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;

public final class OperatorSwitch<T>
implements Observable.Operator<T, Observable<? extends T>> {
    public static <T> OperatorSwitch<T> instance() {
        return Holder.INSTANCE;
    }

    private OperatorSwitch() {
    }

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        SwitchSubscriber<? super T> sws = new SwitchSubscriber<T>(child);
        child.add(sws);
        return sws;
    }

    private static final class InnerSubscriber<T>
    extends Subscriber<T> {
        private final int id;
        private final ProducerArbiter arbiter;
        private final SwitchSubscriber<T> parent;

        InnerSubscriber(int id, ProducerArbiter arbiter, SwitchSubscriber<T> parent) {
            this.id = id;
            this.arbiter = arbiter;
            this.parent = parent;
        }

        @Override
        public void setProducer(Producer p) {
            this.arbiter.setProducer(p);
        }

        @Override
        public void onNext(T t) {
            this.parent.emit(t, this.id, this);
        }

        @Override
        public void onError(Throwable e) {
            this.parent.error(e, this.id);
        }

        @Override
        public void onCompleted() {
            this.parent.complete(this.id);
        }
    }

    private static final class SwitchSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final SerializedSubscriber<T> serializedChild;
        final SerialSubscription ssub;
        final Object guard = new Object();
        final NotificationLite<?> nl = NotificationLite.instance();
        final ProducerArbiter arbiter;
        int index;
        boolean active;
        boolean mainDone;
        List<Object> queue;
        boolean emitting;
        InnerSubscriber<T> currentSubscriber;

        SwitchSubscriber(Subscriber<? super T> child) {
            this.serializedChild = new SerializedSubscriber<T>(child);
            this.arbiter = new ProducerArbiter();
            this.ssub = new SerialSubscription();
            child.add(this.ssub);
            child.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    if (n > 0L) {
                        SwitchSubscriber.this.arbiter.request(n);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Observable<? extends T> t) {
            Object object = this.guard;
            synchronized (object) {
                int id = ++this.index;
                this.active = true;
                this.currentSubscriber = new InnerSubscriber(id, this.arbiter, this);
            }
            this.ssub.set(this.currentSubscriber);
            t.unsafeSubscribe(this.currentSubscriber);
        }

        @Override
        public void onError(Throwable e) {
            this.serializedChild.onError(e);
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                this.mainDone = true;
                if (this.active) {
                    return;
                }
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(this.nl.completed());
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            this.drain(localQueue);
            this.serializedChild.onCompleted();
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emit(T value, int id, InnerSubscriber<T> innerSubscriber) {
            Object object;
            List<Object> localQueue;
            Object object2 = this.guard;
            synchronized (object2) {
                if (id != this.index) {
                    return;
                }
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(value);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    this.drain(localQueue);
                    if (once) {
                        once = false;
                        this.serializedChild.onNext(value);
                        this.arbiter.produced(1L);
                    }
                    object = this.guard;
                    synchronized (object) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            break;
                        }
                    }
                } while (!this.serializedChild.isUnsubscribed());
            }
            finally {
                if (!skipFinal) {
                    object = this.guard;
                    synchronized (object) {
                        this.emitting = false;
                    }
                }
            }
        }

        void drain(List<Object> localQueue) {
            if (localQueue == null) {
                return;
            }
            for (Object o : localQueue) {
                if (this.nl.isCompleted(o)) {
                    this.serializedChild.onCompleted();
                    break;
                }
                if (this.nl.isError(o)) {
                    this.serializedChild.onError(this.nl.getError(o));
                    break;
                }
                Object t = o;
                this.serializedChild.onNext(t);
                this.arbiter.produced(1L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void error(Throwable e, int id) {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (id != this.index) {
                    return;
                }
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(this.nl.error(e));
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            this.drain(localQueue);
            this.serializedChild.onError(e);
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete(int id) {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (id != this.index) {
                    return;
                }
                this.active = false;
                if (!this.mainDone) {
                    return;
                }
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(this.nl.completed());
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            this.drain(localQueue);
            this.serializedChild.onCompleted();
            this.unsubscribe();
        }
    }

    private static final class Holder {
        static final OperatorSwitch<Object> INSTANCE = new OperatorSwitch();

        private Holder() {
        }
    }
}

