/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import rx.Observable;
import rx.Subscriber;
import rx.annotations.Experimental;
import rx.observers.SerializedObserver;
import rx.subjects.Subject;

public class SerializedSubject<T, R>
extends Subject<T, R> {
    private final SerializedObserver<T> observer;
    private final Subject<T, R> actual;

    public SerializedSubject(final Subject<T, R> actual) {
        super(new Observable.OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> child) {
                actual.unsafeSubscribe(child);
            }
        });
        this.actual = actual;
        this.observer = new SerializedObserver(actual);
    }

    @Override
    public void onCompleted() {
        this.observer.onCompleted();
    }

    @Override
    public void onError(Throwable e) {
        this.observer.onError(e);
    }

    @Override
    public void onNext(T t) {
        this.observer.onNext(t);
    }

    @Override
    public boolean hasObservers() {
        return this.actual.hasObservers();
    }

    @Override
    @Deprecated
    @Experimental
    public boolean hasCompleted() {
        return this.actual.hasCompleted();
    }

    @Override
    @Deprecated
    @Experimental
    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    @Override
    @Deprecated
    @Experimental
    public boolean hasValue() {
        return this.actual.hasValue();
    }

    @Override
    @Deprecated
    @Experimental
    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    @Override
    @Deprecated
    @Experimental
    public T getValue() {
        return this.actual.getValue();
    }

    @Override
    @Deprecated
    @Experimental
    public Object[] getValues() {
        return this.actual.getValues();
    }

    @Override
    @Deprecated
    @Experimental
    public T[] getValues(T[] a) {
        return this.actual.getValues(a);
    }
}

