/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security;

import org.gcube.accounting.security.authn.AuthenticationManager;
import org.gcube.accounting.security.authz.Action;
import org.gcube.accounting.security.authz.AuthorizationManager;

public class SecurityManager {
    private static boolean authnEnabled;
    private static boolean authzEnabled;
    private static AuthenticationManager authn;
    private static AuthorizationManager authz;
    private static String authnType;

    public static String getAuthnType() {
        return authnType;
    }

    public static void setAuthnType(String authnType) {
        SecurityManager.authnType = authnType;
    }

    public static AuthenticationManager getAuthenticationManager() {
        return authn;
    }

    public static void setAuthenticationManager(AuthenticationManager authn) {
        SecurityManager.authn = authn;
    }

    public static void setAuthorizationManager(AuthorizationManager authz) {
        SecurityManager.authz = authz;
    }

    public static AuthorizationManager getAuthorizationManager() {
        return authz;
    }

    public static boolean isAuthnEnabled() {
        return authnEnabled;
    }

    public static void setAuthnEnabled(boolean authnEnabled) {
        SecurityManager.authnEnabled = authnEnabled;
    }

    public static boolean isAuthzEnabled() {
        return authzEnabled;
    }

    public static void setAuthzEnabled(boolean authzEnabled) {
        SecurityManager.authzEnabled = authzEnabled;
    }

    public static boolean isAllowed(String userId, Action action) {
        if (!authzEnabled) {
            return true;
        }
        if (authz == null) {
            return false;
        }
        return SecurityManager.getAuthorizationManager().isAllowed(userId, action);
    }

    public static boolean isAllowed(String userId, Action action, String object) {
        if (!authzEnabled) {
            return true;
        }
        if (authz == null) {
            return false;
        }
        return SecurityManager.getAuthorizationManager().isAllowed(userId, action, object);
    }

    public static boolean authenticate(String username, String password) {
        if (!authnEnabled) {
            return true;
        }
        if (authn == null) {
            return false;
        }
        return SecurityManager.getAuthenticationManager().authenticate(username, password);
    }
}

