package org.gcube.accounting.common.helper;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.Property;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * 
 * 
 * @author Ermanno Travaglino (E-IIS)
 *
 */

public class ISClientConnector {

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ISClientConnector.class);
	private String[] server;
	private String env;
	private String clientId;
	private String backendType;
	private static HashMap<String, String[]> isCache;

	public ISClientConnector(){
	}

	public String[] getServer(String resourceType, String scope){
		String savedScope = null;
		if(scope!=null){
			savedScope = ScopeProvider.instance.get();
			ScopeProvider.instance.set(scope);
		}
		logger.trace("get server from IS ");
		if(isCache!=null)
			server=(String[]) isCache.get("MongoDBServer");
		if(server==null){
			if(resourceType.equalsIgnoreCase("runtimeResource")){
				getServerRRFws();
			}
			else
				if(server!=null){
					if(isCache==null)
						isCache = new HashMap<String, String[]>();
						isCache.put("MongoDBServer", server);
						logger.info("ISCACHE: ELEMENT INSERTED ");
				}

		}else{
			logger.info("ISCACHE: ELEMENT EXTRACTED");
		}
		if(scope!=null){
			ScopeProvider.instance.set(savedScope);
		}
		return server;
	}


	public String getEnvironment(String secondaryType, String field){
		return env;
	}

	public String getClientId(String secondaryType, String field){
		return clientId;
	}


	public String[] getServerRRFws(){
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> resources = client.submit(query);

		if(resources.size() >= 1){
			logger.info("found "+resources.size()+" RR ");
			return getServers(resources);
		}
		else{
			logger.error("RUNTIME RESOURCE NOT FOUND IN THIS SCOPE "+ScopeProvider.instance.get());
			throw new RuntimeException("RUNTIME RESOURCE NOT FOUND IN SCOPE: "+ScopeProvider.instance.get());
		}
	}


	private String[] getServers(List<ServiceEndpoint> resources) {
		ServiceEndpoint defaultResource = null;
		logger.info("search RR with priority ");
		// search RR with property DEFAULT	
		for (ServiceEndpoint res : resources){
			String priority = retrievePropertyValue(res, "priority");
			if (priority!=null){
				defaultResource=res;
				logger.info("found a RR with priority: ");
				break;
			}
		}
		if(defaultResource!=null){
			server = new String[defaultResource.profile().accessPoints().size()];
			int i=0;
			for (AccessPoint ap:defaultResource.profile().accessPoints()) {
				if (ap.name().equals("server"+(i+1))) {
					server[i] = ap.address();
					i++;
				}
			}
			backendType = retrievePropertyValue(defaultResource, "type");
			logger.info("Type of backend found in RR is "+backendType);
			return server;

		}else{
			throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
		}
	}


	public String getBackendType(String scope) {
		if (backendType!=null) 
			return backendType;
		
		backendType = retrievePropertyValue("type", scope);
		return backendType;
	}



	private String retrievePropertyValue(String name, String scope) {
		String savedScope=null;
		if(scope!=null){
			savedScope=ScopeProvider.instance.get();
			ScopeProvider.instance.set(scope);
		}
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> resources = client.submit(query);
		ServiceEndpoint res=resources.get(0);
		Iterator<AccessPoint> it= res.profile().accessPoints().iterator();
		AccessPoint ap=(AccessPoint)it.next();
		Map<String, Property>map= ap.propertyMap();
		Property type=map.get(name);
		String value=type.value();
		if(scope!=null){
			ScopeProvider.instance.set(savedScope);
		}
		return value;
	}

	private String retrievePropertyValue(ServiceEndpoint res, String name) {
		Iterator<AccessPoint> it = res.profile().accessPoints().iterator();
		AccessPoint ap = (AccessPoint) it.next();
		Map<String, Property> map = ap.propertyMap();
		Property type = map.get(name);
		if (type!=null)
			return type.value();
		else
			return null;
	}


}