

package org.gcube.accounting.security.authn.filter;

import java.io.IOException;
import java.security.Principal;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.gcube.accounting.security.SecurityManager;
import org.gcube.accounting.security.authn.SecurityTokenThreadLocal;
import org.w3c.dom.Element;



public class FederationFilter implements Filter {

	private static Logger logger = Logger.getLogger(FederationFilter.class);
	private static final String DEFAULT_SECURITY_TOKEN_ATTR = "org.apache.fediz.SECURITY_TOKEN";
	private static final String SECURITY_TOKEN_ATTR_CONFIG = "security.token.attribute";
	
	private String securityTokenAttr = DEFAULT_SECURITY_TOKEN_ATTR;

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		String attrName = filterConfig.getInitParameter(SECURITY_TOKEN_ATTR_CONFIG);
		if (attrName != null) {
			securityTokenAttr = attrName;
		}
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {

		HttpServletRequest httprequest = (HttpServletRequest)request;
		HttpServletResponse httpresponse = (HttpServletResponse)response;

		/**
		 * Nothing to do if authentication is not enabled
		 */
		if (!SecurityManager.isAuthnEnabled()) {
			logger.debug("Authentication is not enabled. Skipping.");
			chain.doFilter(request, response);
			return;
		}

		/**
		 *  Check whether the filter applies or not
		 **/
		if(!"sts".equals(SecurityManager.getAuthnType())) {
			chain.doFilter(request, response);
			return;
		}

		// retrieving session
		HttpSession session = httprequest.getSession(false);
			
		if (request instanceof HttpServletRequest) {
			logger.debug("STS Authentication");
			HttpServletRequest hrequest = (HttpServletRequest)request;
			Element el = (Element)hrequest.getSession().getAttribute(securityTokenAttr);
			
			if (el != null) {
				try
				{
					SecurityTokenThreadLocal.setToken(el);
					Principal p = hrequest.getUserPrincipal();
					logger.debug("Principal user = "+p.getName());
					hrequest.setAttribute("userId", p.getName());
					session = hrequest.getSession();
					session.setAttribute("userId", p.getName());
					chain.doFilter(request, response);
				} finally {
					SecurityTokenThreadLocal.setToken(null);
				}		
			} else {
				chain.doFilter(request, response);
			}

		} else {
			chain.doFilter(request, response);
		}
	}

	@Override
	public void destroy() {
		// TODO Auto-generated method stub

	}

}
