/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.internal.Dimension;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.accounting.datamodel.aggregation.AggregatedJobUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.BasicHarvester;
import org.gcube.dataharvest.utils.DateUtils;
import org.gcube.dataharvest.utils.Utils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInvocationHarvester
extends BasicHarvester {
    private static Logger logger = LoggerFactory.getLogger(MethodInvocationHarvester.class);
    public static final String DATAMINER_SERVICE_NAME = "DataMiner";

    public MethodInvocationHarvester(Date start, Date end) throws Exception {
        super(start, end);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        AccountingPersistenceQuery accountingPersistenceQuery = AccountingPersistenceQueryFactory.getInstance();
        TemporalConstraint temporalConstraint = new TemporalConstraint(this.start.getTime(), this.end.getTime(), TemporalConstraint.AggregationMode.MONTHLY);
        String context = Utils.getCurrentContext();
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.add(context);
        SortedMap result = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Date newMethodInvocationHarvesterStartDate = DateUtils.getStartCalendar(2017, 11, 31).getTime();
        if (this.start.after(newMethodInvocationHarvesterStartDate)) {
            result = accountingPersistenceQuery.getContextTimeSeries(AggregatedJobUsageRecord.class, temporalConstraint, filters, contexts, true);
        } else {
            filters.add(new Filter("serviceName", DATAMINER_SERVICE_NAME));
            result = accountingPersistenceQuery.getContextTimeSeries(AggregatedServiceUsageRecord.class, temporalConstraint, filters, contexts, true);
        }
        ScopeDescriptor scopeDescriptor = AccountingDashboardHarvesterPlugin.getScopeDescriptor(context);
        Dimension dimension = this.getDimension(HarvestedDataKey.METHOD_INVOCATIONS);
        if (result != null) {
            for (Filter filter : result.keySet()) {
                SortedMap infoMap = (SortedMap)result.get(filter);
                Calendar calendar = DateUtils.dateToCalendar(this.start);
                Info info = (Info)infoMap.get(calendar);
                logger.debug("{} : {}", (Object)DateUtils.format(calendar), (Object)info);
                JSONObject jsonObject = info.getValue();
                long numberOfInvocation = jsonObject.getLong("operationCount");
                AccountingRecord accountingRecord = new AccountingRecord(scopeDescriptor, this.instant, dimension, Long.valueOf(numberOfInvocation));
                accountingRecords.add(accountingRecord);
            }
        } else {
            logger.error("No data found.");
        }
        return accountingRecords;
    }
}

