/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.insert.rstudio.plugin;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;
import org.gcube.accounting.insert.rstudio.persistence.AggregatorPersistenceBackendQueryConfiguration;
import org.gcube.accounting.insert.rstudio.plugin.AccountingInsertRstudioPluginDeclaration;
import org.gcube.accounting.insert.rstudio.utils.Constant;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.persistence.PersistenceCouchBase;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingInsertRstudioPlugin
extends Plugin<AccountingInsertRstudioPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(AccountingInsertRstudioPlugin.class);
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout((long)(Constant.CONNECTION_TIMEOUT * 1000)).maxRequestLifetime((long)(Constant.MAX_REQUEST_LIFE_TIME * 1000)).queryTimeout((long)(Constant.CONNECTION_TIMEOUT * 1000)).viewTimeout((long)(Constant.VIEW_TIMEOUT_BUCKET * 1000)).keepAliveInterval(3600000L).kvTimeout(5000L).build();

    public AccountingInsertRstudioPlugin(AccountingInsertRstudioPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        String line;
        String context = ScopeProvider.instance.get();
        logger.debug("AccountingInsertRstudioPlugin launch on context:{}", (Object)context);
        String url = null;
        String password = null;
        String bucket = null;
        try {
            AggregatorPersistenceBackendQueryConfiguration configuration = new AggregatorPersistenceBackendQueryConfiguration(PersistenceCouchBase.class);
            url = configuration.getProperty("URL");
            password = configuration.getProperty("password");
            bucket = configuration.getProperty("AggregatedStorageStatusRecord");
        }
        catch (Exception e) {
            logger.error("AccountingInsertRstudioPlugin launch", (Object)e.getLocalizedMessage());
            throw e;
        }
        logger.debug("AccountingInsertRstudioPlugin open cluster:{}", (Object)context);
        CouchbaseCluster cluster = CouchbaseCluster.create((CouchbaseEnvironment)ENV, (String[])new String[]{url});
        Bucket accountingBucket = cluster.openBucket(bucket, password);
        String dataServiceClass = "content-management";
        if (inputs.containsKey("dataServiceClass")) {
            dataServiceClass = (String)inputs.get("dataServiceClass");
        }
        String dataServiceName = "storage-manager";
        if (inputs.containsKey("dataServiceName")) {
            dataServiceName = (String)inputs.get("dataServiceName");
        }
        String dataServiceId = "";
        String uri = "RStudio";
        if (inputs.containsKey("uri")) {
            uri = (String)inputs.get("uri");
        }
        String dataType = "STORAGE";
        if (inputs.containsKey("dataType")) {
            dataType = (String)inputs.get("dataType");
        }
        Integer timeWait = 1000;
        if (inputs.containsKey("timeWait")) {
            timeWait = (Integer)inputs.get("timeWait");
        }
        String pathFile = null;
        if (inputs.containsKey("pathFile")) {
            pathFile = (String)inputs.get("pathFile");
        }
        if (pathFile == null) {
            throw new IllegalArgumentException("Path File is null!!");
        }
        JsonDocument document = null;
        JsonObject content = null;
        BufferedReader reader = new BufferedReader(new FileReader(pathFile));
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            logger.debug("AccountingInsertRstudioPlugin line :{}", (Object)line);
            String[] infoUser = line.split("\\s+");
            String user = infoUser[1];
            Long dataVolume = Long.parseLong(infoUser[0]);
            if (inputs.containsKey("unitVolume")) {
                switch ((String)inputs.get("unitVolume")) {
                    case "Kilobyte": {
                        dataVolume = AccountingInsertRstudioPlugin.kilToByte(dataVolume);
                        break;
                    }
                    case "Megabyte": {
                        dataVolume = this.megaToByte(dataVolume);
                    }
                }
            }
            try {
                String docId = UUID.randomUUID().toString();
                logger.debug("AccountingInsertRstudioPlugin User:{} dataVolume:{} KB", (Object)user, (Object)AccountingInsertRstudioPlugin.bytesToKil(dataVolume));
                logger.debug("AccountingInsertRstudioPlugin User:{} dataVolume:{} bytes", (Object)user, (Object)dataVolume);
                dataServiceId = InetAddress.getLocalHost().getHostName();
                Long dataCount = 0L;
                Long timeStamp = System.currentTimeMillis();
                content = JsonObject.empty().put("scope", context);
                content.put("operationCount", 1);
                content.put("dataCount", (Object)dataCount);
                content.put("endTime", (Object)timeStamp);
                content.put("consumerId", user);
                content.put("startTime", (Object)timeStamp);
                content.put("id", docId);
                content.put("dataVolume", (Object)dataVolume);
                content.put("dataType", dataType);
                content.put("operationResult", "SUCCESS");
                content.put("dataServiceClass", dataServiceClass);
                content.put("dataServiceName", dataServiceName);
                content.put("dataServiceId", dataServiceId);
                content.put("aggregated", true);
                content.put("providerId", uri);
                content.put("creationTime", (Object)timeStamp);
                content.put("recordType", "StorageStatusRecord");
                document = JsonDocument.create((String)"docId", (JsonObject)content);
                JsonDocument doc = JsonDocument.create((String)docId, (JsonObject)content);
                accountingBucket.upsert((Document)doc);
                logger.debug("upsert doc:{}", (Object)doc.toString());
                Thread.sleep(timeWait.intValue());
            }
            catch (Exception e) {
                logger.error("doc:{} not insert ({}), problem with exist bucket", new Object[]{document.id(), document.toString(), e});
                logger.error("force insert into list for insert");
            }
        }
        logger.trace("AccountingInsertRstudioPlugin close");
        reader.close();
        cluster.disconnect();
    }

    protected void onStop() throws Exception {
        logger.trace("{} onStop() function", (Object)((Object)((Object)this)).getClass().getSimpleName());
        Thread.currentThread().interrupt();
    }

    private static long bytesToMeg(long bytes) {
        return bytes / 0x100000L;
    }

    private static long bytesToKil(long bytes) {
        return bytes / 1024L;
    }

    private static long kilToByte(long kilobytes) {
        return kilobytes * 1024L;
    }

    private Long megaToByte(Long megaToByte) {
        return megaToByte * 0x100000L;
    }
}

