/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.insert.storage.plugin;

import java.net.HttpURLConnection;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageStatusRecord;
import org.gcube.accounting.insert.storage.utils.HTTPUtility;
import org.gcube.accounting.insert.storage.utils.SocialService;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.documentstore.records.Record;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingInsertStoragePlugin
extends Plugin {
    private static Logger logger = LoggerFactory.getLogger(AccountingInsertStoragePlugin.class);
    protected static final String ALL_USERS_PATH = "2/users/get-all-usernames";
    protected static final String RESPONSE_SUCCESS_KEY = "success";
    protected static final String RESPONSE_MESSAGE_KEY = "message";
    protected static final String RESULT_KEY = "result";
    protected ObjectMapper objectMapper = new ObjectMapper();

    public void launch(Map<String, Object> inputs) throws Exception {
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        Set<String> users = this.getAllUsers();
        for (String consumerId : users) {
            IClient client = new StorageClient("", "", consumerId, AccessType.PUBLIC, MemoryType.PERSISTENT).getClient();
            StorageStatusRecord storageStatusRecord = new StorageStatusRecord();
            try {
                Long dataVolume = Long.parseLong(client.getTotalUserVolume());
                Long dataCount = Long.parseLong(client.getUserTotalItems());
                storageStatusRecord.setConsumerId(consumerId);
                storageStatusRecord.setDataVolume(dataVolume.longValue());
                storageStatusRecord.setDataCount(dataCount.longValue());
                storageStatusRecord.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
                storageStatusRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
                storageStatusRecord.setProviderURI(new URI("data.d4science.org"));
                accountingPersistence.account((Record)storageStatusRecord);
            }
            catch (Exception e) {
                logger.error("Error while accounting {} for {} for user {}", new Object[]{storageStatusRecord.getRecordType(), AbstractStorageUsageRecord.DataType.STORAGE, consumerId});
            }
        }
    }

    private Set<String> getAllUsers() throws Exception {
        Object basePath = SocialService.getSocialService().getServiceBasePath();
        if (basePath == null) {
            logger.error("Unable to get users because there is no social networking service available");
            throw new Exception("Unable to get users because there is no social networking service available");
        }
        basePath = ((String)basePath).endsWith("/") ? basePath : (String)basePath + "/";
        GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)basePath);
        Secret secret = SecretManagerProvider.get();
        Map authHeader = secret.getHTTPAuthorizationHeaders();
        if (authHeader != null && !authHeader.isEmpty()) {
            for (Map.Entry entry : authHeader.entrySet()) {
                gxhttpStringRequest.header((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            logger.warn("No authentication header found for Accounting Insert Storage Plugin.This may lead to unauthorized access.");
        }
        gxhttpStringRequest.from(AccountingInsertStoragePlugin.class.getSimpleName());
        gxhttpStringRequest.path(ALL_USERS_PATH);
        HttpURLConnection httpURLConnection = gxhttpStringRequest.get();
        String ret = HTTPUtility.getResultAsString(httpURLConnection);
        JsonNode jsonNode = this.objectMapper.readTree(ret);
        if (!jsonNode.get(RESPONSE_SUCCESS_KEY).asBoolean()) {
            logger.info("Failed to get users. Reason {}", (Object)jsonNode.get(RESPONSE_MESSAGE_KEY).asText());
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode.get(RESULT_KEY);
        HashSet<String> users = new HashSet<String>(arrayNode.size());
        for (int i = 0; i < arrayNode.size(); ++i) {
            users.add(arrayNode.get(i).asText());
        }
        return users;
    }

    protected void onStop() throws Exception {
        logger.trace("AccountingInsertStoragePlugin: {} onStop() function", (Object)((Object)((Object)this)).getClass().getSimpleName());
        Thread.currentThread().interrupt();
    }
}

