/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.net.URI;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class AccountingPersistenceConfiguration {
    protected final String SERVICE_ENDPOINT_CATEGORY = "Accounting";
    protected final String SERVICE_ENDPOINT_NAME = "Persistence";
    protected static final String PERSISTENCE_CLASS_NAME = "persistenceClassName";
    protected URI uri;
    protected String username;
    protected String password;
    protected Map<String, ServiceEndpoint.Property> propertyMap;

    protected void init() {
        this.propertyMap = new HashMap<String, ServiceEndpoint.Property>();
    }

    public AccountingPersistenceConfiguration() {
        this.init();
    }

    public AccountingPersistenceConfiguration(URI uri, String username, String password) {
        this.init();
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    public AccountingPersistenceConfiguration(String persistenceClassName) throws Exception {
        this.init();
        ServiceEndpoint serviceEndpoint = this.getServiceEndpoint(persistenceClassName);
        this.setValues(serviceEndpoint);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProperty(String propertyKey) throws Exception {
        ServiceEndpoint.Property propertyValue = this.propertyMap.get(propertyKey);
        String value = propertyValue.value();
        if (propertyValue.isEncrypted()) {
            value = AccountingPersistenceConfiguration.decrypt(value, new Key[0]);
        }
        return value;
    }

    protected ServiceEndpoint getServiceEndpoint(String persistenceClassName) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", "Accounting"));
        query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'", "Persistence"));
        query.addCondition(String.format("$resource/Profile/AccessPoint/Properties/Property/Name/text() eq '%s'", PERSISTENCE_CLASS_NAME));
        query.addCondition(String.format("$resource/Profile/AccessPoint/Properties/Property/Value/text() eq '%s'", persistenceClassName));
        query.setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List serviceEndpoints = client.submit((Query)query);
        return (ServiceEndpoint)serviceEndpoints.get(0);
    }

    private static String decrypt(String encrypted, Key ... key) throws Exception {
        return StringEncrypter.getEncrypter().decrypt(encrypted, new Key[0]);
    }

    protected void setValues(ServiceEndpoint serviceEndpoint) throws Exception {
        Group accessPoints = serviceEndpoint.profile().accessPoints();
        for (ServiceEndpoint.AccessPoint accessPoint : accessPoints) {
            String password;
            this.uri = new URI(accessPoint.address());
            this.username = accessPoint.username();
            String encryptedPassword = accessPoint.password();
            this.password = password = AccountingPersistenceConfiguration.decrypt(encryptedPassword, new Key[0]);
            this.propertyMap = accessPoint.propertyMap();
        }
    }
}

