/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.security.Key;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class AccountingPersistenceConfiguration
extends PersistenceBackendConfiguration {
    protected static final String TARGET_SCOPE = "targetScope";
    protected static final String SERVICE_ENDPOINT_CATEGORY = "Accounting";
    protected static final String SERVICE_ENDPOINT_NAME = "Persistence";
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String USERNAME_PROPERTY_KEY = "username";
    public static final String PASSWORD_PROPERTY_KEY = "password";

    public AccountingPersistenceConfiguration() {
    }

    public AccountingPersistenceConfiguration(Class<? extends PersistenceBackend> clz) throws Exception {
        super(clz);
        ServiceEndpoint serviceEndpoint = this.getServiceEndpoint(SERVICE_ENDPOINT_CATEGORY, SERVICE_ENDPOINT_NAME, clz);
        this.setValues(serviceEndpoint, clz);
    }

    protected ServiceEndpoint getServiceEndpoint(String serviceEndpointCategory, String serviceEndpointName, Class<? extends PersistenceBackend> clz) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", serviceEndpointCategory));
        query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'", serviceEndpointName));
        query.addCondition(String.format("$resource/Profile/AccessPoint/Interface/Endpoint/@EntryName eq '%s'", clz.getSimpleName()));
        query.setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List serviceEndpoints = client.submit((Query)query);
        if (serviceEndpoints.size() > 1) {
            query.addCondition(String.format("$resource/Profile/AccessPoint/Properties/Property/Name/text() eq '%s'", TARGET_SCOPE));
            query.addCondition(String.format("$resource/Profile/AccessPoint/Properties/Property/Value/text() eq '%s'", ScopeProvider.instance.get()));
            serviceEndpoints = client.submit((Query)query);
        }
        return (ServiceEndpoint)serviceEndpoints.get(0);
    }

    private static String decrypt(String encrypted, Key ... key) throws Exception {
        return StringEncrypter.getEncrypter().decrypt(encrypted, new Key[0]);
    }

    protected void setValues(ServiceEndpoint serviceEndpoint, Class<? extends PersistenceBackend> clz) throws Exception {
        Group accessPoints = serviceEndpoint.profile().accessPoints();
        for (ServiceEndpoint.AccessPoint accessPoint : accessPoints) {
            if (accessPoint.name().compareTo(clz.getSimpleName()) != 0) continue;
            this.addProperty(URL_PROPERTY_KEY, accessPoint.address());
            this.addProperty(USERNAME_PROPERTY_KEY, accessPoint.username());
            String encryptedPassword = accessPoint.password();
            String password = AccountingPersistenceConfiguration.decrypt(encryptedPassword, new Key[0]);
            this.addProperty(PASSWORD_PROPERTY_KEY, password);
            Map propertyMap = accessPoint.propertyMap();
            for (String key : propertyMap.keySet()) {
                ServiceEndpoint.Property property = (ServiceEndpoint.Property)propertyMap.get(key);
                String value = property.value();
                if (property.isEncrypted()) {
                    value = AccountingPersistenceConfiguration.decrypt(value, new Key[0]);
                }
                this.addProperty(key, value);
            }
        }
    }
}

