/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.service;

import org.gcube.accounting.aggregator.RegexRulesAggregator;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.ApplicationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AccountingServiceInitializer
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(AccountingServiceInitializer.class);

    public static String getCurrentContext() {
        AuthorizationEntry authorizationEntry;
        String token = SecurityTokenProvider.instance.get();
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    public static String getCurrentContext(String token) throws ObjectNotFound, Exception {
        AuthorizationEntry authorizationEntry = Constants.authorizationService().get(token);
        String context = authorizationEntry.getContext();
        logger.info("Context of token {} is {}", (Object)token, (Object)context);
        return context;
    }

    public void onInit() {
        String context = AccountingServiceInitializer.getCurrentContext();
        logger.debug("\n-------------------------------------------------------\nAccounting Service is Starting on context {}\n-------------------------------------------------------", (Object)context);
        AccountingPersistenceFactory.getPersistence();
        AccountingPersistenceQueryFactory.getInstance();
        RegexRulesAggregator.getInstance();
    }

    public void onShutdown() {
        String context = AccountingServiceInitializer.getCurrentContext();
        logger.trace("\n-------------------------------------------------------\nAccounting Service is Stopping on context {}\n-------------------------------------------------------", (Object)context);
        try {
            AccountingPersistenceFactory.getPersistence().close();
            AccountingPersistenceQueryFactory.getInstance().close();
            RegexRulesAggregator.getInstance().stop();
            logger.trace("\n-------------------------------------------------------\nAccounting Service Stopped Successfully on context {}\n-------------------------------------------------------", (Object)context);
        }
        catch (Exception e) {
            logger.error("Error while stopping Accounting Service on context {}", (Object)context, (Object)e);
        }
    }
}

