/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.accounting.summary.access.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.gcube.accounting.accounting.summary.access.AccountingDao;
import org.gcube.accounting.accounting.summary.access.ParameterException;
import org.gcube.accounting.accounting.summary.access.impl.BasicConnectionManager;
import org.gcube.accounting.accounting.summary.access.impl.BasicContextTreeProvider;
import org.gcube.accounting.accounting.summary.access.impl.ConnectionManager;
import org.gcube.accounting.accounting.summary.access.impl.ContextTreeProvider;
import org.gcube.accounting.accounting.summary.access.impl.Queries;
import org.gcube.accounting.accounting.summary.access.model.MeasureResolution;
import org.gcube.accounting.accounting.summary.access.model.Record;
import org.gcube.accounting.accounting.summary.access.model.Report;
import org.gcube.accounting.accounting.summary.access.model.ReportElement;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.Series;
import org.gcube.accounting.accounting.summary.access.model.internal.Dimension;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.accounting.accounting.summary.access.model.update.UpdateReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingDaoImpl
implements AccountingDao {
    private static final Logger log = LoggerFactory.getLogger(AccountingDaoImpl.class);
    private static final ZoneId UTC = ZoneId.of("UTC");
    private ContextTreeProvider treeProvider = null;
    private ConnectionManager connectionManager = null;
    private static final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("yyyy-MM");

    public AccountingDaoImpl() {
        this.connectionManager = new BasicConnectionManager();
        this.treeProvider = new BasicContextTreeProvider();
    }

    public void setTreeProvider(ContextTreeProvider treeProvider) {
        this.treeProvider = treeProvider;
    }

    public AccountingDaoImpl(ContextTreeProvider treeProvider, ConnectionManager connectionManager) {
        this.treeProvider = treeProvider;
        this.connectionManager = connectionManager;
    }

    @Override
    public Report getReportByScope(ScopeDescriptor desc, Instant from, Instant to, MeasureResolution resolution) throws SQLException, ParameterException {
        DateTimeFormatter formatter = AccountingDaoImpl.getFormatter(resolution);
        log.info("Loading report {} for {} between {} and {} ", new Object[]{resolution, desc.getId(), formatter.format(from.atZone(UTC).toLocalDateTime()), formatter.format(to.atZone(UTC).toLocalDateTime())});
        long startReportTime = System.currentTimeMillis();
        if (from.isAfter(to)) {
            throw new ParameterException("Irregular time interval: \"From\" parameter cannot be after \"To\" parameter.");
        }
        int timeSlices = (int)AccountingDaoImpl.getRangeSize(from, to, resolution);
        Connection conn = this.connectionManager.getConnection();
        Queries queries = new Queries(conn);
        ResultSet dimensionRS = queries.getAvailableDimensions(from, to, desc, resolution);
        LinkedList<Dimension> foundDimensions = new LinkedList<Dimension>();
        while (dimensionRS.next()) {
            String id = dimensionRS.getString("id");
            String label = dimensionRS.getString("LABEL");
            String group = dimensionRS.getString("dimension_group");
            String aggregatedDim = dimensionRS.getString("aggregated_measure");
            foundDimensions.add(new Dimension(id, label, aggregatedDim, group));
        }
        log.debug("Found {} dimensions to load. ", (Object)foundDimensions.size());
        LinkedList<ReportElement> reports = new LinkedList<ReportElement>();
        for (Dimension entry : foundDimensions) {
            String xLabel = "Time";
            String yLabel = entry.getLabel();
            String category = entry.getGroup();
            reports.add(new ReportElement(desc.getName() + " " + yLabel, category, xLabel, yLabel, new Series[]{this.getSeries(queries, from, to, entry, desc, resolution, timeSlices)}));
            if (!desc.hasChildren()) continue;
            LinkedList<Series> childrenSeries = new LinkedList<Series>();
            for (ScopeDescriptor child : desc.getChildren()) {
                childrenSeries.add(this.getSeries(queries, from, to, entry, child, resolution, timeSlices));
            }
            reports.add(new ReportElement(desc.getName() + " children " + yLabel, category, xLabel, yLabel, childrenSeries.toArray(new Series[childrenSeries.size()])));
        }
        log.info("Loaded {} report elements in {} ms", (Object)reports.size(), (Object)(System.currentTimeMillis() - startReportTime));
        return new Report(reports);
    }

    @Override
    public ScopeDescriptor getTree(Object request) throws Exception {
        return this.treeProvider.getTree(request);
    }

    @Override
    public Set<Dimension> getDimensions() throws SQLException {
        Connection conn = this.connectionManager.getConnection();
        Queries q = new Queries(conn);
        ResultSet rs = q.listDimensions();
        HashSet<Dimension> toReturn = new HashSet<Dimension>();
        while (rs.next()) {
            String id = rs.getString("id");
            String label = rs.getString("LABEL");
            String group = rs.getString("dimension_group");
            String aggregatedMeasure = rs.getString("aggregated_measure");
            toReturn.add(new Dimension(id, label, aggregatedMeasure, group));
        }
        return toReturn;
    }

    @Override
    public Set<ScopeDescriptor> getContexts() throws SQLException {
        Connection conn = this.connectionManager.getConnection();
        Queries q = new Queries(conn);
        ResultSet rs = q.listContexts();
        HashSet<ScopeDescriptor> toReturn = new HashSet<ScopeDescriptor>();
        while (rs.next()) {
            String id = rs.getString("id");
            String label = rs.getString("LABEL");
            toReturn.add(new ScopeDescriptor(label, id));
        }
        return toReturn;
    }

    @Override
    public UpdateReport insertRecords(AccountingRecord ... toInsert) throws SQLException {
        log.trace("Preapring to insert {} records.", (Object)toInsert.length);
        Set<Dimension> existingDimensions = this.getDimensions();
        Set<ScopeDescriptor> existingContexts = this.getContexts();
        Connection conn = this.connectionManager.getConnection();
        log.debug("Loaded {} existing dimensions and {} contexts ", (Object)existingDimensions.size(), (Object)existingContexts.size());
        Queries q = new Queries(conn);
        PreparedStatement psMeasure = q.getMeasureInsertionPreparedStatement();
        PreparedStatement psContexts = q.getContextInsertionPreparedStatement();
        PreparedStatement psDimensions = q.getDimensionInsertionPreparedStatement();
        long writeMeasureCounter = 0L;
        HashSet<Dimension> insertedDimensions = new HashSet<Dimension>();
        HashSet<ScopeDescriptor> insertedContexts = new HashSet<ScopeDescriptor>();
        long previousMeasureCount = q.getMeasureCount("monthly");
        log.debug("Actually registering records..");
        for (AccountingRecord record : toInsert) {
            Dimension dim = record.getDimension();
            ScopeDescriptor context = record.getContext();
            if (!existingDimensions.contains(dim)) {
                log.debug("Registering {} ", (Object)dim);
                psDimensions.setString(1, dim.getId());
                psDimensions.setString(2, dim.getLabel());
                psDimensions.setString(3, dim.getGroup());
                psDimensions.setString(4, dim.getAggregatedMeasure());
                if (psDimensions.executeUpdate() == 0) {
                    throw new SQLException("Error registering Dimension : No inserted rows");
                }
                insertedDimensions.add(dim);
                existingDimensions.add(dim);
            }
            if (!existingContexts.contains(context)) {
                log.debug("Registering {} ", (Object)context);
                psContexts.setString(1, context.getId());
                psContexts.setString(2, context.getName());
                if (psContexts.executeUpdate() == 0) {
                    throw new SQLException("Error registering Context : No inserted rows");
                }
                insertedContexts.add(context);
                existingContexts.add(context);
            }
            psMeasure.setString(1, context.getId());
            psMeasure.setString(2, dim.getId());
            psMeasure.setTimestamp(3, new Timestamp(record.getTime().toEpochMilli()));
            psMeasure.setLong(4, record.getMeasure());
            psMeasure.setLong(5, record.getMeasure());
            if (psMeasure.executeUpdate() == 0) {
                throw new SQLException("Error registering Measure : No inserted rows");
            }
            ++writeMeasureCounter;
        }
        conn.commit();
        long resultingMeasureCount = q.getMeasureCount("monthly");
        log.trace("Done inserting {} rows. Registered {} dimensions and {} contexts.", new Object[]{writeMeasureCounter, insertedDimensions.size(), insertedContexts.size()});
        return new UpdateReport(previousMeasureCount, resultingMeasureCount, writeMeasureCounter, insertedContexts, insertedDimensions);
    }

    private static final long getRangeSize(Instant from, Instant to, MeasureResolution resolution) throws ParameterException {
        log.debug("Evaluating time range between {} , {} [{}]", new Object[]{from, to, resolution});
        Period d = Period.between(LocalDateTime.ofInstant(from, UTC).toLocalDate(), LocalDateTime.ofInstant(to, UTC).toLocalDate());
        switch (resolution) {
            case MONTHLY: {
                return d.get(ChronoUnit.MONTHS) + d.get(ChronoUnit.YEARS) * 12L + 1L;
            }
        }
        throw new ParameterException("Invalid resolution " + resolution);
    }

    private static Instant increment(Instant toIncrement, MeasureResolution res, int offset) {
        switch (res) {
            case MONTHLY: {
                return LocalDateTime.ofInstant(toIncrement, UTC).plus(offset, ChronoUnit.MONTHS).toInstant(ZoneOffset.UTC);
            }
        }
        throw new RuntimeException("Unexpected Resolution " + res);
    }

    private static DateTimeFormatter getFormatter(MeasureResolution res) {
        switch (res) {
            case MONTHLY: {
                return monthFormatter;
            }
        }
        throw new RuntimeException("Unexpected Resolution " + res);
    }

    private Series getSeries(Queries queries, Instant from, Instant to, Dimension dim, ScopeDescriptor scope, MeasureResolution res, int timeSlices) throws SQLException {
        Record[] records = new Record[timeSlices];
        PreparedStatement ps = queries.prepareMeasuresByDimension(scope, res);
        DateTimeFormatter formatter = AccountingDaoImpl.getFormatter(res);
        Instant currentTimeSlice = from;
        for (int i = 0; i < timeSlices; ++i) {
            currentTimeSlice = AccountingDaoImpl.increment(from, res, i);
            Timestamp t = new Timestamp(currentTimeSlice.toEpochMilli());
            ps.setTimestamp(1, t);
            ps.setTimestamp(2, t);
            ps.setString(3, dim.getId());
            ResultSet rs = ps.executeQuery();
            Record toSet = new Record(formatter.format(LocalDateTime.ofInstant(currentTimeSlice, UTC)), 0L);
            if (rs.next()) {
                toSet.setY(rs.getLong("measure"));
            }
            records[i] = toSet;
        }
        return new Series(scope.getName(), records);
    }
}

