

package org.gcube.accounting.usagetracker.rest.resources.reports;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.AggregatedResult;
import org.gcube.accounting.datamodel.reports.storagestatus.StorageStatusReport;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;
import org.joda.time.Period;

@Path("/reports/job")
public class JobReports {
		
	private static Logger logger = Logger.getLogger(JobReports.class);

	protected @Context HttpServletRequest request;


	
	@POST
	@Path("jobs")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public Collection<AggregatedResult> getCountJobsReport(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getJobCountJobsReport(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("elapsed-time")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public Collection<AggregatedResult> getElapsedTimeReport(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getJobElapsedTimeReport(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("net-elapsed-time")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public Collection<AggregatedResult> getNetElapsedTimeReport(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getJobNetElapsedTimeReport(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	
	
	
	


}
