

package org.gcube.accounting.usagetracker.configuration;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.log4j.Logger;
import org.gcube.accounting.webservice.configuration.CommonConfigurator;

public class StartupListener implements ServletContextListener {

	private static final String loggingConfigurationFile = "gcube-accounting-usagetracker-log4j.properties";

	private static Logger logger = Logger.getLogger(StartupListener.class);

	private CommonConfigurator ac;

	public void contextInitialized(ServletContextEvent event) {
		System.out.println(loggingConfigurationFile);
		this.ac = new CommonConfigurator();
		this.ac.configureLogging(loggingConfigurationFile);
		this.ac.configureProxy(Configuration.getInstance());
		this.ac.configureAuthentication(Configuration.getInstance());
		this.ac.configureAuthorization(Configuration.getInstance());
	}

	public void contextDestroyed(ServletContextEvent event) {
		this.ac.destroy();
	}

}
