

package org.gcube.accounting.usagetracker.rest.resources.filters;

import java.net.UnknownHostException;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.FilterRating;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

@Path("/filters/job/")
public class JobFilters {
		
	private static Logger logger = Logger.getLogger(JobFilters.class);

	protected @Context HttpServletRequest request;



	
	@POST
	@Path("jobs")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public FilterRating getCountJobsFilter(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getJobCountJobsFilter(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("elapsed-time")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public FilterRating getElapsedTimeFilter(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getJobElapsedTimeFilter(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("net-elapsed-time")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public FilterRating getNetElapsedTime(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getJobNetElapsedTimeFilter(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	

	
	


}
