/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources.filters;

import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.FilterRating;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

@Path(value="/filters/task/")
public class TaskFilters {
    private static Logger logger = Logger.getLogger(TaskFilters.class);
    @Context
    protected HttpServletRequest request;

    @POST
    @Path(value="processors")
    @Produces(value={"application/xml"})
    public FilterRating getCountProcessorsFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getTaskCountProcessorsFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="worker-time")
    @Produces(value={"application/xml"})
    public FilterRating getWorkerTimeFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getTaskWorkerTimeFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="network-traffic")
    @Produces(value={"application/xml"})
    public FilterRating getNetworkTrafficFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            if (report.getReportProperty().equals("rsp:overallNetworkIn")) {
                return db.getTaskNetworkTrafficInputFilter(report);
            }
            if (report.getReportProperty().equals("rsp:overallNetworkOut")) {
                return db.getTaskNetworkTrafficOutputFilter(report);
            }
            return new FilterRating();
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }
}

