/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.couchdb.query;

import java.net.SocketTimeoutException;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import org.ektorp.DbAccessException;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryFactory;
import org.gcube.accounting.couchdb.query.CouchDBQueryPluginDeclaration;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBQueryPlugin
extends Plugin<CouchDBQueryPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(CouchDBQueryPlugin.class);
    public static final String DELAY_MILLIS = "delay";
    public static final long RETRY_DELAY_MILLIS = 60000L;
    public static final long DEFAULT_DELAY_MILLIS = 120000L;
    public static final int MONTH_INTERVAL = 3;
    public static final int QUERY_MONTH_INTERVAL = 2;

    public CouchDBQueryPlugin(CouchDBQueryPluginDeclaration pluginDeclaration) {
        super(pluginDeclaration);
    }

    @Override
    public void launch(Map<String, Object> inputs) throws Exception {
        logger.debug("Launching {}", (Object)this.getClass().getSimpleName());
        long delay = 120000L;
        if (inputs != null && inputs.containsKey(DELAY_MILLIS)) {
            try {
                delay = new Long(inputs.get(DELAY_MILLIS).toString());
            }
            catch (Exception e) {
                logger.warn("The provided value {} for {} is not a long. Default value {} will be used", new Object[]{inputs.get(DELAY_MILLIS), DELAY_MILLIS, 120000L, e});
            }
        } else {
            logger.debug("No provided value for {}. Default value {} will be used", (Object)DELAY_MILLIS, (Object)120000L);
        }
        AccountingPersistenceBackendQuery apq = AccountingPersistenceBackendQueryFactory.getInstance();
        Map map = RecordUtility.getAggregatedRecordClassesFound();
        for (Class recordClass : map.values()) {
            try {
                Set<String> queryKey = apq.getKeys(recordClass);
                Calendar startTime = Calendar.getInstance();
                int month = startTime.get(2);
                if (month >= 2) {
                    startTime.set(2, month - 2);
                } else {
                    startTime.set(1, startTime.get(1) - 1);
                    startTime.set(2, 11 - (2 - startTime.get(2)));
                }
                Calendar endTime = Calendar.getInstance();
                boolean iterate = true;
                int i = 4;
                while (iterate) {
                    try {
                        TemporalConstraint temporalConstraint = new TemporalConstraint(startTime.getTimeInMillis(), endTime.getTimeInMillis(), TemporalConstraint.AggregationMode.MONTHLY);
                        apq.query(recordClass, temporalConstraint, null);
                        logger.debug("Going to query possible values for retrieved keys");
                        for (String key : queryKey) {
                            logger.debug("Getting possible values for key {}", (Object)key);
                            apq.getPossibleValuesForKey(recordClass, key);
                        }
                        iterate = false;
                    }
                    catch (DbAccessException ex) {
                        if (ex.getCause() instanceof SocketTimeoutException && i < 6) {
                            long retryInterval = 60000L * (long)i;
                            logger.error("{} retry in {} millis", (Object)ex.getCause().getClass().getSimpleName(), (Object)retryInterval);
                            iterate = true;
                            ++i;
                            Thread.sleep(retryInterval);
                            continue;
                        }
                        throw ex;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                }
                logger.debug("Waiting {} millis before quering the next UsageRecord", (Object)delay);
                Thread.sleep(delay);
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
        }
        logger.debug("{} has finished", (Object)this.getClass().getSimpleName());
    }

    @Override
    protected void onStop() throws Exception {
        logger.debug("{} onStop() function", (Object)this.getClass().getSimpleName());
    }
}

