/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet.utils;

import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.net.URL;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMap;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.ClientResource;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.CompoundMapItem;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.types.ClientResourceType;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.uriresolvermanager.UriResolverManager;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelTranslation {
    private static final Logger logger = LoggerFactory.getLogger(ModelTranslation.class);

    public static final ClientResource toClient(Resource res) {
        ClientResource toReturn = new ClientResource();
        toReturn.setAlgorithm(AlgorithmType.valueOf((String)(res.getAlgorithm() + "")));
        toReturn.setAuthor(res.getAuthor());
        toReturn.setDescription(res.getDescription());
        toReturn.setDisclaimer(res.getDisclaimer());
        toReturn.setHcafIds(CSVUtils.listToCSV((List)res.getSourceHCAFIds()));
        toReturn.setHcafNames(CSVUtils.listToCSV((List)res.getSourceHCAFTables()));
        toReturn.setHspenIds(CSVUtils.listToCSV((List)res.getSourceHSPENIds()));
        toReturn.setHspenNames(CSVUtils.listToCSV((List)res.getSourceHSPENTables()));
        toReturn.setHspecIds(CSVUtils.listToCSV((List)res.getSourceHSPECIds()));
        toReturn.setHspecNames(CSVUtils.listToCSV((List)res.getSourceHSPECTables()));
        toReturn.setOccurrIds(CSVUtils.listToCSV((List)res.getSourceOccurrenceCellsIds()));
        toReturn.setOccurNames(CSVUtils.listToCSV((List)res.getSourceOccurrenceCellsTables()));
        toReturn.setIsDefault(res.getDefaultSource());
        try {
            toReturn.setParameters(Field.toJSONArray((List)res.getParameters()).toString());
        }
        catch (JSONException e) {
            logger.error("Unable to parse resource parameters, resource is  " + res, (Throwable)e);
        }
        toReturn.setProvenance(res.getProvenance());
        toReturn.setRowCount(res.getRowCount());
        toReturn.setSearchId(Integer.valueOf(res.getSearchId()));
        toReturn.setStatus(res.getStatus() + "");
        toReturn.setTableName(res.getTableName());
        toReturn.setTime(new Time(res.getGenerationTime()));
        toReturn.setTitle(res.getTitle());
        toReturn.setType(ClientResourceType.valueOf((String)(res.getType() + "")));
        return toReturn;
    }

    public static final Resource toServer(ClientResource res) {
        Resource toReturn = new Resource(ResourceType.valueOf((String)(res.getType() + "")), res.getSearchId().intValue());
        toReturn.setAlgorithm(org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.AlgorithmType.valueOf((String)(res.getAlgorithm() + "")));
        toReturn.setAuthor(res.getAuthor());
        toReturn.setDefaultSource(res.getIsDefault());
        toReturn.setDescription(res.getDescription());
        toReturn.setDisclaimer(res.getDisclaimer());
        toReturn.setGenerationTime(Long.valueOf(res.getTime().getTime()));
        try {
            toReturn.setParameters(Field.fromJSONArray((JSONArray)new JSONArray(res.getParameters())));
        }
        catch (JSONException e) {
            logger.error("Unable to parse resource parameters, client resource is " + res, (Throwable)e);
        }
        toReturn.setProvenance(res.getProvenance());
        toReturn.setRowCount(res.getRowCount());
        toReturn.setSourceHCAFIds(CSVUtils.CSVTOIntegerList((String)res.getHcafIds()));
        toReturn.setSourceHCAFTables(CSVUtils.CSVToStringList((String)res.getHcafNames()));
        toReturn.setSourceHSPENIds(CSVUtils.CSVTOIntegerList((String)res.getHspenIds()));
        toReturn.setSourceHSPENTables(CSVUtils.CSVToStringList((String)res.getHspenNames()));
        toReturn.setSourceHSPECIds(CSVUtils.CSVTOIntegerList((String)res.getHspecIds()));
        toReturn.setSourceHSPECTables(CSVUtils.CSVToStringList((String)res.getHspecNames()));
        toReturn.setSourceOccurrenceCellsIds(CSVUtils.CSVTOIntegerList((String)res.getOccurrIds()));
        toReturn.setSourceOccurrenceCellsTables(CSVUtils.CSVToStringList((String)res.getOccurNames()));
        toReturn.setStatus(ResourceStatus.valueOf((String)res.getStatus()));
        toReturn.setTableName(res.getTableName());
        toReturn.setTitle(res.getTitle());
        return toReturn;
    }

    public static CompoundMapItem toClient(AquaMap map) {
        CompoundMapItem toReturn = new CompoundMapItem();
        String thumbnail = null;
        try {
            toReturn.setAlgorithm(map.getResource().getAlgorithm() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setAuthor(map.getAuthor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setCoverage(map.getCoverage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setCreationDate(map.getCreationDate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setDataGenerationTime(map.getResource().getGenerationTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setFileSetId(map.getFileSetId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setGis(Boolean.valueOf(map.isGis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setCustom(map.isCustom());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setImageCount(Integer.valueOf(map.getFiles().size()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ArrayList<String> urls = new ArrayList<String>();
            for (File f : map.getFiles()) {
                urls.add(f.getUuri());
                if (!f.getName().equals("Earth")) continue;
                thumbnail = f.getUuri();
            }
            toReturn.setImageList(CSVUtils.listToCSV(urls));
        }
        catch (Exception urls) {
            // empty catch block
        }
        try {
            if (thumbnail == null) {
                thumbnail = map.getFiles().size() > 0 ? ((File)map.getFiles().get(0)).getUuri() : "";
            }
            toReturn.setImageThumbNail(thumbnail);
        }
        catch (Exception urls) {
            // empty catch block
        }
        try {
            LayerInfo layer = map.getLayer();
            String layerID = ModelTranslation.getUUIDbyGSId((String)layer.getName());
            String layerUrl = ModelTranslation.getPublicLink((String)layerID);
            toReturn.setLayerUrl(layerUrl);
            toReturn.setLayerId(layerID);
            URL url = new URL(layer.getUrl());
            String previewUrl = "http://" + url.getHost() + "/geoserver/wms?service=WMS&version=1.1.0&request=GetMap&layers=aquamaps:TrueMarble.16km.2700x1350,aquamaps:" + layer.getName() + "&styles=&bbox=-180.0,-85.5,180.0,90.0&width=676&height=330&srs=EPSG:4326&format=image%2Fgif";
            toReturn.setLayerPreview(previewUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setResourceId(Integer.valueOf(map.getResource().getSearchId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setSpeciesList(map.getSpeciesCsvList());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setTitle(map.getTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            toReturn.setType(map.getMapType() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return toReturn;
    }

    private static String getPublicLink(String uuid) throws UriResolverMapException, IllegalArgumentException {
        UriResolverManager resolver = new UriResolverManager("GIS");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("gis-UUID", uuid);
        params.put("scope", ScopeProvider.instance.get());
        return resolver.getLink(params, true);
    }

    private static String getUUIDbyGSId(String gsID) throws Exception {
        GeoNetworkAdministration reader = GeoNetwork.get();
        reader.login(LoginLevel.ADMIN);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, gsID);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = reader.query(req);
        return resp.getMetadata(0).getUUID();
    }
}

