/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.implementations.executions;

import lombok.NonNull;
import org.gcube.application.cms.plugins.faults.InsufficientPrivileges;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.reports.DocumentHandlingReport;
import org.gcube.application.cms.plugins.requests.BaseExecutionRequest;
import org.gcube.application.geoportal.common.model.plugins.OperationDescriptor;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.HandlerDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuardedExecution<R extends BaseExecutionRequest, T extends DocumentHandlingReport> {
    private static final Logger log = LoggerFactory.getLogger(GuardedExecution.class);
    protected T result = null;
    @NonNull
    private OperationDescriptor op;
    protected T theReport;
    protected HandlerDeclaration config = null;

    protected void checks() throws ConfigurationException, InsufficientPrivileges {
        if (this.theReport.getTheRequest() == null) {
            throw new RuntimeException("Unexpected state : request cannot be null");
        }
        if (this.op.getAppliableToPhases() != null && !this.op.getAppliableToPhases().isEmpty()) {
            String currentPhase = this.theReport.getTheRequest().getDocument().getLifecycleInformation().getPhase();
            if (!this.op.getAppliableToPhases().contains(currentPhase)) {
                new StepException("Document must be in one of the following phases : " + this.op.getAppliableToPhases());
            }
        }
    }

    public T execute() throws Exception {
        log.trace("Executing {} ", (Object)this.theReport.getTheRequest());
        this.checks();
        this.result = this.run();
        log.trace("Report is {} ", this.theReport);
        return this.result;
    }

    public T getResult() {
        return this.result;
    }

    protected abstract T run() throws Exception;

    public GuardedExecution<R, T> setTheReport(T theReport) {
        this.theReport = theReport;
        return this;
    }

    public void setHandlerConfiguration(HandlerDeclaration config) {
        this.config = config;
    }

    public GuardedExecution(@NonNull OperationDescriptor op) {
        if (op == null) {
            throw new NullPointerException("op is marked @NonNull but is null");
        }
        this.op = op;
    }

    @NonNull
    public OperationDescriptor getOp() {
        return this.op;
    }
}

