/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.engine.bboxes;

import java.util.List;
import org.bson.Document;
import org.gcube.application.cms.sdi.engine.bboxes.BBOXEvaluator;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GCubeSDILayer;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBOXPathScanner
extends BBOXEvaluator {
    private static final Logger log = LoggerFactory.getLogger(BBOXPathScanner.class);

    public BBOXPathScanner() {
        super("BBOX PATH SCANNER");
    }

    @Override
    public boolean isConfigured(Document profileConfiguration) {
        return profileConfiguration.containsKey((Object)"bboxEvaluation");
    }

    @Override
    public GCubeSDILayer.BBOX evaluate(Document profileConfiguration, UseCaseDescriptor useCaseDescriptor, JSONPathWrapper documentNavigator) {
        List bboxEvaluationPaths = (List)profileConfiguration.get((Object)"bboxEvaluation", List.class);
        GCubeSDILayer.BBOX toSet = null;
        for (Object pathObj : bboxEvaluationPaths) {
            log.debug("UseCaseDescriptor {} : Evaluating path {} ", (Object)useCaseDescriptor.getId(), pathObj);
            List bboxObjects = documentNavigator.getByPath(pathObj.toString());
            log.debug("UseCaseDescriptor {} : Evaluating path {} .. results {} ", new Object[]{useCaseDescriptor.getId(), pathObj, bboxObjects});
            for (Object bboxObject : bboxObjects) {
                log.info("Matched path {}, value is {} ", (Object)pathObj.toString(), bboxObject);
                GCubeSDILayer.BBOX box = (GCubeSDILayer.BBOX)Serialization.convert(bboxObject, GCubeSDILayer.BBOX.class);
                if (toSet == null) {
                    toSet = box;
                }
                if (box.getMaxX() > toSet.getMaxX()) {
                    toSet.setMaxX(box.getMaxX());
                }
                if (box.getMaxY() > toSet.getMaxY()) {
                    toSet.setMaxY(box.getMaxY());
                }
                if (box.getMinX() < toSet.getMinX()) {
                    toSet.setMinX(box.getMinX());
                }
                if (!(box.getMinY() < toSet.getMinY())) continue;
                toSet.setMinY(box.getMinY());
            }
        }
        return toSet;
    }
}

