package org.gcube.application.enm.service.conn;

import java.util.UUID;

import org.gcube.application.enm.Constants;
import org.gcube.application.enm.context.ServiceContext;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;

/**
 * Utility class to access the gCube storage service.
 * 
 * @author Erik Torres <ertorser@upv.es>
 */
public class StorageClientUtil {

	public static final String OPENBIO_BASE_DIR = "eubrazilopenbio";

	public static IClient client() {
		IClient client = null;
		try {
			client = new StorageClient(
					Constants.SERVICE_CLASS,
					Constants.SERVICE_NAME, 
					Constants.SERVICE_NAME, 
					AccessType.SHARED, 
					ServiceContext.getContext().getScope()).getClient();
		} catch (Exception e) {
			client = null;
		}
		return client;
	}

	public static String experimentBaseDir(final String credentials,
			final UUID experimentId) {
		return userBaseDir(credentials) + experimentId.toString() + "/";
	}
	
	public static String userBaseDir(final String credentials) {
		return OPENBIO_BASE_DIR + "/" + credentials + "/";
	}

}
