/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.xml.datatype.DatatypeConfigurationException;
import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.application.enm.common.xml.status.ObjectFactory;
import org.gcube.application.enm.common.xml.status.OperationType;
import org.gcube.application.enm.common.xml.status.OperationTypeType;
import org.gcube.application.enm.common.xml.status.PastOperationsType;
import org.gcube.application.enm.common.xml.status.StatusType;
import org.gcube.application.enm.service.ExecutionResource;
import org.gcube.application.enm.service.util.XmlHelper;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class GenericJob
implements Callable<String>,
Comparable<GenericJob> {
    protected GCUBELog logger = new GCUBELog(GenericJob.class);
    public static int MINIMUM_PRIORITY = 20;
    public static int MAXIMUM_PRIORITY = 0;
    protected final UUID uuid;
    protected final ExperimentRequest request;
    protected final ExperimentStatus status;
    protected final ExperimentResults results;
    protected final ExperimentLogs logs;
    private int priority;
    private boolean cancelled = false;

    public GenericJob(UUID uuid, ExperimentRequest request) {
        this(uuid, request, GenericJob.initialStatus(), GenericJob.initialResults(), GenericJob.initialLogs());
    }

    public GenericJob(UUID uuid, ExperimentRequest request, ExperimentStatus status, ExperimentResults results, ExperimentLogs logs) {
        this.logger.trace((Object)"Constructor...");
        this.uuid = uuid;
        this.request = request;
        this.status = status;
        this.results = results;
        this.logs = logs;
        this.setPriority(MINIMUM_PRIORITY);
    }

    private static ExperimentStatus initialStatus() {
        ObjectFactory factory = new ObjectFactory();
        ExperimentStatus initialStatus = factory.createExperimentStatus();
        initialStatus.setStatus(StatusType.PENDING);
        initialStatus.setCompletenessPercentage(new BigDecimal(0));
        try {
            initialStatus.setStartDate(XmlHelper.now());
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
        initialStatus.setEndDate(null);
        initialStatus.setExecutionTrace(factory.createExecutionTraceType());
        OperationType currentOperation = factory.createOperationType();
        OperationTypeType operation = factory.createOperationTypeType();
        operation.setOperationId(BigInteger.valueOf(-1L));
        currentOperation.setOperation(operation);
        initialStatus.getExecutionTrace().setCurrentOperation(currentOperation);
        PastOperationsType pastOperations = factory.createPastOperationsType();
        initialStatus.getExecutionTrace().setPastOperations(pastOperations);
        return initialStatus;
    }

    private static ExperimentResults initialResults() {
        ExperimentResults initialResults = new org.gcube.application.enm.common.xml.results.ObjectFactory().createExperimentResults();
        return initialResults;
    }

    private static ExperimentLogs initialLogs() {
        ExperimentLogs initialLogs = new org.gcube.application.enm.common.xml.logs.ObjectFactory().createExperimentLogs();
        return initialLogs;
    }

    protected void next(int step, String jobId) {
        String[] jobIds = new String[]{jobId};
        this.next(step, jobIds);
    }

    protected void next(int step, List<String> jobIds) {
        this.next(step, jobIds.toArray(new String[jobIds.size()]));
    }

    protected void next(int step, String[] jobIds) {
        ObjectFactory factory = new ObjectFactory();
        OperationType newOperation = factory.createOperationType();
        OperationTypeType operation = factory.createOperationTypeType();
        operation.setOperationId(BigInteger.valueOf(step));
        if (jobIds != null && jobIds.length > 0) {
            operation.getRemoteJobId().addAll(Arrays.asList(jobIds));
        }
        newOperation.setOperation(operation);
        if (this.status.getExecutionTrace().getCurrentOperation() != null) {
            this.status.getExecutionTrace().getPastOperations().getPastOperation().add(this.status.getExecutionTrace().getCurrentOperation());
        }
        this.status.getExecutionTrace().setCurrentOperation(newOperation);
    }

    protected int currentStep() {
        return this.currenOperation().getOperationId().intValue();
    }

    protected List<String> currentJobIds() {
        return this.currenOperation().getRemoteJobId() != null ? this.currenOperation().getRemoteJobId() : new ArrayList();
    }

    private OperationTypeType currenOperation() {
        return this.status.getExecutionTrace().getCurrentOperation().getOperation();
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final ExperimentRequest getRequest() {
        return this.request;
    }

    public final ExperimentStatus getStatus() {
        return this.status;
    }

    public final ExperimentResults getResults() {
        return this.results;
    }

    public final ExperimentLogs getLogs() {
        return this.logs;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public final boolean isCanceled() {
        return this.cancelled;
    }

    public final void cancel() {
        this.priority = MAXIMUM_PRIORITY;
        this.cancelled = true;
    }

    public abstract ExecutionResource getExecutionResource();

    @Override
    public int compareTo(GenericJob other) {
        return other == null || other.uuid == null || other.priority < MINIMUM_PRIORITY || other.priority > MAXIMUM_PRIORITY ? -1 : -Integer.valueOf(other.priority).compareTo(this.priority);
    }

    public boolean equals(Object other) {
        if (other instanceof GenericJob) {
            return this.uuid == ((GenericJob)other).uuid;
        }
        return false;
    }
}

