package org.gcube.application.enm.service.conn;

/**
 * Flags the sections of an experiment that need to be updated. Use this class
 * with {@link JobMonitor} to persist the changes to the persistent storage of
 * the service.
 * 
 * @author Erik Torres <ertorser@upv.es>
 */
public class JobUpdate {
	private boolean statusChange;
	private boolean resultsChange;
	private boolean logsChange;
	public JobUpdate() {
		this(true, true, true);
	}
	public JobUpdate(final boolean statusChange, 
			final boolean resultsChange, final boolean logsChange) {
		this.statusChange = statusChange;
		this.resultsChange = resultsChange;
		this.logsChange = logsChange;
	}
	public final boolean isStatusChange() {
		return statusChange;
	}
	public final boolean isResultsChange() {
		return resultsChange;
	}		
	public final boolean isLogsChange() {
		return logsChange;
	}		
	public final JobUpdate status(final boolean changed) {
		statusChange = changed;
		return this;
	}
	public final JobUpdate results(final boolean changed) {
		resultsChange = changed;
		return this;
	}
	public final JobUpdate logs(final boolean changed) {
		logsChange = changed;
		return this;
	}	
}
