/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.gbifplugin.search;

import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.gcube.application.speciesmanager.gbifplugin.Constants;
import org.gcube.application.speciesmanager.gbifplugin.search.Utils;
import org.gcube.application.speciesmanager.stubs.model.ResultItem;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Capabilities;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Property;
import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;

public class GBIFSearch {
    private GCUBELog logger = new GCUBELog(GBIFSearch.class);
    private String species;
    private String providerKey;
    private String dataSetKey;
    private Property[] properties;
    private String dataprovider;
    private String baseURL;
    private static XMLInputFactory ifactory = XMLInputFactory.newInstance();

    public GBIFSearch(String baseURL, String species, Property ... properties) {
        this.species = species.replaceAll(" ", "%20");
        this.properties = properties;
        this.baseURL = baseURL;
    }

    public void search(ObjectWriter<ResultItem> writer) throws Exception {
        this.logger.debug((Object)("starting search with species " + this.species));
        URL url = new URL(String.valueOf(this.baseURL) + "taxon/list?scientificname=" + this.species);
        InputStream is = url.openConnection().getInputStream();
        XMLEventReader eventReader = ifactory.createXMLEventReader(is);
        String nextResultsLink = null;
        URL nextresultURL = null;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "nextRequestUrl")) {
                event = eventReader.nextEvent();
                nextResultsLink = event.asCharacters().getData();
                continue;
            }
            if (!Utils.checkStartElement(event, "dataProviders")) continue;
            this.pagingSearch(eventReader, writer);
            if (nextResultsLink == null) continue;
            nextresultURL = new URL(nextResultsLink);
            is = nextresultURL.openConnection().getInputStream();
            eventReader = ifactory.createXMLEventReader(is);
        }
        writer.close();
        this.logger.debug((Object)("search finished for species " + this.species));
    }

    private void pagingSearch(XMLEventReader eventReader, ObjectWriter<ResultItem> writer) throws Exception {
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "dataProvider")) {
                this.retrieveDataProvider(eventReader, event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue(), writer);
                continue;
            }
            if (Utils.checkEndElement(event, "dataProviders")) break;
        }
    }

    private void retrieveDataProvider(XMLEventReader eventReader, String gbifKey, ObjectWriter<ResultItem> writer) throws Exception {
        List<Object> trees = new ArrayList();
        Edge dataProviderEdge = Nodes.e((String)"dataProvider", (Node)Nodes.n((String)gbifKey, (Edge[])new Edge[0]));
        this.providerKey = gbifKey;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "name")) {
                event = eventReader.nextEvent();
                this.dataprovider = event.asCharacters().getData();
                ((InnerNode)dataProviderEdge.target()).add(Nodes.e((String)"name", (Object)this.dataprovider));
                continue;
            }
            if (Utils.checkStartElement(event, "dataResource")) {
                trees = this.retrieveDataSet(eventReader, event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue(), event.asStartElement().getAttributeByName(Constants.ABOUT_ATTR).getValue(), dataProviderEdge);
                continue;
            }
            if (!Utils.checkEndElement(event, "dataProvider")) continue;
            for (Tree tree : trees) {
                writer.put((Object)ResultItem.fromTree((Tree)tree));
            }
        }
    }

    private List<Tree> retrieveDataSet(XMLEventReader eventReader, String resourceId, String resourceUri, Edge dataproviderEdge) throws Exception {
        List<Tree> trees = new ArrayList<Tree>();
        this.dataSetKey = resourceId;
        Edge dataSetEdge = Nodes.e((String)"dataSet", (Node)Nodes.n((String)resourceId, (Edge[])new Edge[]{dataproviderEdge}));
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "name")) {
                ((InnerNode)dataSetEdge.target()).add(Nodes.e((String)"name", (Object)Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "citation")) {
                ((InnerNode)dataSetEdge.target()).add(Nodes.e((String)"citation", (Object)Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "taxonConcepts")) {
                trees = this.retrieveTaxons(eventReader, false);
                continue;
            }
            if (Utils.checkEndElement(event, "dataResource")) break;
        }
        for (Tree t : trees) {
            t.add(dataSetEdge);
        }
        return trees;
    }

    private List<Tree> retrieveTaxons(XMLEventReader eventReader, boolean onlyUri) throws Exception {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        while (eventReader.hasNext()) {
            Tree tree;
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "TaxonConcept") && (tree = this.retrieveEntireTaxon(event.asStartElement().getAttributeByName(Constants.ABOUT_ATTR).getValue())) != null) {
                String taxonConceptKey = event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue();
                String productsId = Utils.createProductsId(this.species, this.providerKey, this.dataSetKey, taxonConceptKey);
                Edge occurrenceEdge = Nodes.e((String)"product", (Node)Nodes.n((String)productsId, (Edge[])new Edge[]{Nodes.e((String)"type", (Object)Capabilities.Occurences), Nodes.e((String)"count", (Object)this.occurrencesCount(taxonConceptKey))}));
                tree.add(Nodes.e((String)"products", (Node)Nodes.n((Edge[])new Edge[]{occurrenceEdge})));
                Calendar now = Calendar.getInstance();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                String credits = "Biodiversity occurrence data published by: " + this.dataprovider + " (Accessed through GBIF Data Portal, data.gbif.org, " + format.format(now.getTime()) + ")";
                tree.add(Nodes.e((String)"credits", (Object)credits));
                trees.add(tree);
            }
            if (Utils.checkEndElement(event, "taxonConcepts")) break;
        }
        return trees;
    }

    private Tree retrieveEntireTaxon(String resourceUri) throws Exception {
        URL url = new URL(resourceUri);
        InputStream is = url.openConnection().getInputStream();
        XMLEventReader eventReader = ifactory.createXMLEventReader(is);
        Stack<Edge> stack = new Stack<Edge>();
        String toTaxon = null;
        while (eventReader.hasNext()) {
            String taxonKey;
            Edge edge;
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "TaxonConcept") && (edge = this.retrieveTaxonIternal(eventReader, taxonKey = event.asStartElement().getAttributeByName(Constants.GBIFKEY_ATTR).getValue(), toTaxon)) != null) {
                toTaxon = edge.target().attribute("taxonRelation");
                stack.push(edge);
            }
            if (Utils.checkEndElement(event, "taxonConcepts")) break;
        }
        if (stack.isEmpty()) {
            return null;
        }
        Edge edge = (Edge)stack.pop();
        while (!stack.isEmpty()) {
            Edge tempEdge = (Edge)stack.pop();
            ((InnerNode)tempEdge.target()).add(edge);
            edge = tempEdge;
        }
        return Nodes.t((String)edge.target().id(), (Edge[])((InnerNode)edge.target()).edges().toArray(new Edge[0]));
    }

    private Edge retrieveTaxonIternal(XMLEventReader eventReader, String taxonKey, String oldTaxonValue) throws Exception {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        boolean isChild = false;
        String toTaxon = null;
        String uri = "http://data.gbif.org/ws/rest/taxon/get/" + taxonKey;
        boolean isPrimary = false;
        boolean hasRelationship = false;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "nameComplete")) {
                edges.add(Nodes.e((String)"scientificName", (Object)Utils.readCharacters(eventReader)));
            }
            if (Utils.checkStartElement(event, "rankString")) {
                edges.add(Nodes.e((String)"rank", (Object)Utils.readCharacters(eventReader)));
            }
            if (Utils.checkStartElement(event, "accordingToString")) {
                edges.add(Nodes.e((String)"citation", (Object)Utils.readCharacters(eventReader)));
            }
            if (Utils.checkStartElement(event, "primary")) {
                isPrimary = Utils.readCharacters(eventReader).equals("true");
            }
            if (Utils.checkStartElement(event, "Relationship")) {
                hasRelationship = true;
                while (!Utils.checkEndElement(event, "Relationship")) {
                    event = eventReader.nextEvent();
                    if (Utils.checkStartElement(event, "relationshipCategory")) {
                        isChild = event.asStartElement().getAttributeByName(Constants.RESOURCE_ATTR).getValue().equals("http://rs.tdwg.org/ontology/voc/TaxonConcept#IsChildTaxonOf");
                    }
                    if (!Utils.checkStartElement(event, "toTaxon")) continue;
                    toTaxon = event.asStartElement().getAttributeByName(Constants.RESOURCE_ATTR).getValue();
                }
                if (!isChild) continue;
                break;
            }
            if (Utils.checkEndElement(event, "TaxonConcept")) break;
        }
        if (isPrimary || isChild && uri.equals(oldTaxonValue) || !hasRelationship && uri.equals(oldTaxonValue)) {
            Edge returnEdge = Nodes.e((String)"parent", (Node)Nodes.n((String)taxonKey, (Edge[])edges.toArray(new Edge[edges.size()])));
            returnEdge.target().setAttribute("taxonRelation", toTaxon);
            return returnEdge;
        }
        return null;
    }

    private String occurrencesCount(String taxonKey) throws Exception {
        String occurrencesCount = "0";
        URL url = new URL("http://data.gbif.org/ws/rest/occurrence/count?scientificname=" + this.species + "&dataproviderkey=" + this.providerKey + "&dataresourcekey=" + this.dataSetKey + "&taxonconceptkey=" + taxonKey + "&coordinatestatus=true" + Utils.elaborateProps(this.properties));
        InputStream is = url.openConnection().getInputStream();
        XMLEventReader countEventReader = ifactory.createXMLEventReader(is);
        while (countEventReader.hasNext()) {
            XMLEvent countEvent = countEventReader.nextEvent();
            if (!Utils.checkStartElement(countEvent, "summary")) continue;
            occurrencesCount = countEvent.asStartElement().getAttributeByName(Constants.TOTAL_MATCHED_ATTR).getValue();
            break;
        }
        return occurrencesCount;
    }
}

