/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.gbifplugin.search;

import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.gcube.application.speciesmanager.gbifplugin.search.Utils;
import org.gcube.application.speciesmanager.stubs.model.BasisOfRecord;
import org.gcube.application.speciesmanager.stubs.model.Occurrence;
import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.common.core.utils.logging.GCUBELog;

public class OccurrenceSearch {
    private static XMLInputFactory ifactory = XMLInputFactory.newInstance();
    private static GCUBELog logger = new GCUBELog(OccurrenceSearch.class);

    public static void getOccurrences(String id, ObjectWriter<Occurrence> writer) throws Exception {
        URL url = new URL("http://data.gbif.org/ws/rest/occurrence/list?" + Utils.elaborateProductsId(id) + "&coordinatestatus=true&format=darwin");
        logger.trace((Object)("retrieving occurrences with key http://data.gbif.org/ws/rest/occurrence/list?" + Utils.elaborateProductsId(id) + "&coordinatestatus=true&format=darwin"));
        InputStream is = url.openConnection().getInputStream();
        XMLEventReader eventReader = ifactory.createXMLEventReader(is);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!Utils.checkStartElement(event, "TaxonOccurrence")) continue;
            OccurrenceSearch.retrieveOccurrence(eventReader, writer);
        }
    }

    private static void retrieveOccurrence(XMLEventReader eventReader, ObjectWriter<Occurrence> writer) throws Exception {
        Occurrence occurrence = new Occurrence();
        while (eventReader.hasNext()) {
            Calendar calendar;
            SimpleDateFormat df;
            XMLEvent event = eventReader.nextEvent();
            if (Utils.checkStartElement(event, "collectionCode")) {
                occurrence.setCollectionCode(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "institutionCode")) {
                occurrence.setInstitutionCode(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "catalogNumber")) {
                occurrence.setCatalogueNumber(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "collector")) {
                occurrence.setRecordedBy(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "country")) {
                occurrence.setCountry(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "locality")) {
                occurrence.setLocality(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "earliestDateCollected")) {
                df = new SimpleDateFormat("yyyy-MM-dd");
                calendar = Calendar.getInstance();
                calendar.setTime(df.parse(Utils.readCharacters(eventReader)));
                occurrence.setEventDate(calendar);
                continue;
            }
            if (Utils.checkStartElement(event, "latestDateCollected")) {
                df = new SimpleDateFormat("yyyy-MM-dd");
                calendar = Calendar.getInstance();
                calendar.setTime(df.parse(Utils.readCharacters(eventReader)));
                occurrence.setModified(calendar);
                continue;
            }
            if (Utils.checkStartElement(event, "decimalLatitude")) {
                occurrence.setDecimalLatitude(Double.parseDouble(Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "decimalLongitude")) {
                occurrence.setDecimalLongitude(Double.parseDouble(Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "nameComplete")) {
                occurrence.setScientificName(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "maximumDepthInMeters")) {
                occurrence.setMaxDepth(Double.parseDouble(Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "minimumDepthInMeters")) {
                occurrence.setMinDepth(Double.parseDouble(Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "coordinateUncertaintyInMeters")) {
                occurrence.setCountry(Utils.readCharacters(eventReader));
                continue;
            }
            if (Utils.checkStartElement(event, "basisOfRecordString")) {
                occurrence.setBasisOfRecord(OccurrenceSearch.matchBasisOfRecord(Utils.readCharacters(eventReader)));
                continue;
            }
            if (Utils.checkStartElement(event, "citation")) {
                occurrence.setCitation(Utils.readCharacters(eventReader));
                continue;
            }
            if (!Utils.checkEndElement(event, "TaxonOccurrence")) continue;
            writer.put((Object)occurrence);
            break;
        }
    }

    private static BasisOfRecord matchBasisOfRecord(String value) {
        BasisOfRecord[] basisOfRecordArray = BasisOfRecord.values();
        int n = basisOfRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasisOfRecord record = basisOfRecordArray[n2];
            if (record.name().toLowerCase().equals(value.toLowerCase())) {
                return record;
            }
            ++n2;
        }
        if (value.toLowerCase().equals("S".toLowerCase())) {
            return BasisOfRecord.PreservedSpecimen;
        }
        if (value.toLowerCase().equals("O".toLowerCase())) {
            return BasisOfRecord.HumanObservation;
        }
        if (value.toLowerCase().equals("fossil")) {
            return BasisOfRecord.FossilSpecimen;
        }
        logger.info((Object)("basisOfRecord is " + value));
        return BasisOfRecord.HumanObservation;
    }
}

