/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.gbifplugin.search;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Coordinate;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Property;

public class Utils {
    protected static String elaborateProps(Property[] properties) throws Exception {
        StringBuilder props = new StringBuilder();
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            switch (prop.getProp()) {
                case CoordinateFrom: {
                    Coordinate coordFrom = (Coordinate)prop.getValue();
                    props.append("&minlatitude=" + coordFrom.getLatitude());
                    props.append("&");
                    props.append("minlongitude=" + coordFrom.getLongitude());
                    break;
                }
                case CoordinateTo: {
                    Coordinate coordTo = (Coordinate)prop.getValue();
                    props.append("&maxlatitude=" + coordTo.getLatitude());
                    props.append("&");
                    props.append("maxlongitude=" + coordTo.getLongitude());
                    break;
                }
                case DateFrom: {
                    Calendar dateFrom = (Calendar)prop.getValue();
                    SimpleDateFormat dfFrom = new SimpleDateFormat("yyyy-MM-dd");
                    props.append("&startdate=" + dfFrom.format(dateFrom.getTime()));
                    break;
                }
                case DateTo: {
                    Calendar dateTo = (Calendar)prop.getValue();
                    SimpleDateFormat dfdfTo = new SimpleDateFormat("yyyy-MM-dd");
                    props.append("&enddate=" + dfdfTo.format(dateTo.getTime()));
                    break;
                }
            }
            ++n2;
        }
        return props.toString();
    }

    protected static String elaborateProductsId(String id) {
        String[] splitString = id.split("\\|\\|");
        return "scientificname=" + splitString[0] + "&dataproviderkey=" + splitString[1] + "&dataresourcekey=" + splitString[2] + "&taxonconceptkey=" + splitString[3];
    }

    protected static String createProductsId(String scientificName, String dataProviderKey, String dataResourceKey, String taxonConceptKey) {
        return String.valueOf(scientificName) + "||" + dataProviderKey + "||" + dataResourceKey + "||" + taxonConceptKey;
    }

    protected static boolean checkStartElement(XMLEvent event, String value) {
        return event.getEventType() == 1 && event.asStartElement().getName().getLocalPart().equals(value);
    }

    protected static boolean checkEndElement(XMLEvent event, String value) {
        return event.getEventType() == 2 && event.asEndElement().getName().getLocalPart().equals(value);
    }

    protected static String readCharacters(XMLEventReader eventReader) throws Exception {
        String characters = "";
        XMLEvent event = eventReader.nextEvent();
        while (eventReader.hasNext() && event.isCharacters()) {
            characters = String.valueOf(characters) + event.asCharacters().getData() + " ";
            event = eventReader.nextEvent();
        }
        return characters.trim();
    }
}

