package org.gcube.application.reporting;

import java.util.ArrayList;

import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;

public interface Sequentiable {
	/**
	 * add an empty fillable heading
	 * @param level of the heading
	 * @return true if the operation is performed with success, false otherwise
	 * @throws IllegalArgumentException if the heading is not [1, 5]
	 */
	boolean addHeading(int level) throws IllegalArgumentException;
	/**
	 * add an heading with a non editable content
	 * @param level of the heading
	 * @param content the content you want to show in the heading
	 * @return true if the operation is performed with success, false otherwise
	 * @throws IllegalArgumentException if the heading is not [1, 5]
	 */
	boolean addHeading(int level, String content) throws IllegalArgumentException;
	/**
	 * 
	 * @param level of the heading
	 * @param content the content you want to show in the heading
	 * @param isReadonly tells wether the user can edit the content ot not
	 * @return true if the operation is performed with success, false otherwise
	 * @throws IllegalArgumentException if the heading is not [1, 5]
	 */
	boolean addHeading(int level, String content, boolean isReadonly) throws IllegalArgumentException;
	/**
	 * add an empty fillable text input
	 * @param properties additional properties that one may need, optional
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTextInput(Metadata... properties);
	/**
	 * add a text input with some pre entered text
	 * @param content the content you want to show in the textbox
	 * @param properties additional properties that one may need, optional
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTextInput(String content, Metadata... properties);
	/**
	 * add text input
	 * @param content the content you want to show in the textbox
	 * @param isReadonly tells wether the user can edit the content ot not
	 * @param properties additional properties that one may need, optional
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTextInput(String content, boolean isReadonly, Metadata... properties);
	/**
	 * Add a attribute component to the model instance, allow to specify if is editable or not
	 * @param type the type of the component
	 * @param payload the payload, a text if is a heading or body, an encoded base64 string if an image and so on
	 * @param isEditable allow the component to be edited or not
	 */ 
	boolean addAttributeComponent(String attrName, ArrayList<Attribute> values, boolean allowMultiselection);
	/**
	 * add the references of a given type
	 * @param ref @see {@link ReferenceReport} 
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addReference(ReferenceReport ref);

}
