package org.gcube.application.reporting.component;

import java.util.ArrayList;
import java.util.List;

import org.gcube.application.reporting.Property;
import org.gcube.application.reporting.component.type.ReportComponentType;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;

public abstract class AbstractComponent implements ReportComponent {
	private String id;
	private List<Property> properties;
	
	public AbstractComponent() {
		super();
		this.id = "-1";
		this.properties = new ArrayList<Property>();
	}
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public List<Property> getProperties() {
		return properties;
	}
	public void setProperties(List<Property> properties) {
		this.properties = properties;
	}
	
	protected List<Metadata> convertProperties() {
		List<Metadata> metadata = new ArrayList<Metadata>();
		for (Property p : properties) 
			metadata.add(new Metadata(p.getKey(), p.getValue()));
		return metadata;
	}
	
	public abstract BasicComponent getModelComponent();

	@Override
	public abstract ReportComponentType getType();

	@Override
	public abstract boolean hasChildren();

	@Override
	public abstract List<ReportComponent> getChildren();

	@Override
	public abstract String getStringValue();
}
