package org.gcube.application.reporting.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.application.reporting.ComponentBuilder;
import org.gcube.application.reporting.Property;
import org.gcube.application.reporting.Sequentiable;
import org.gcube.application.reporting.component.AbstractComponent;
import org.gcube.application.reporting.component.Box;
import org.gcube.application.reporting.component.BoxesArea;
import org.gcube.application.reporting.component.Heading;
import org.gcube.application.reporting.component.Instruction;
import org.gcube.application.reporting.component.ReportComponent;
import org.gcube.application.reporting.component.TextInput;
import org.gcube.application.reporting.component.type.ReportComponentType;
import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.RepeatableSequence;

public class ReportSequence extends AbstractComponent implements Sequentiable {
	
	private List<BasicComponent> sequence; 
	private List<ReportComponent> children; 
	/**
	 * 
	 */
	public ReportSequence(String id) {
		setId(id);
		sequence = new ArrayList<BasicComponent>();
		children = new ArrayList<ReportComponent>();
	}
	
	@Override
	public boolean addHeading(int level) throws IllegalArgumentException {
		return addHeading(level, "", false);
	}

	@Override
	public boolean addHeading(int level, String content) throws IllegalArgumentException {
		return addHeading(level, content, false);
	}

	@Override
	public boolean addHeading(int level, String content, boolean isReadonly) throws IllegalArgumentException {
		Heading toAdd = new Heading(level, content, isReadonly);
		children.add(toAdd);
		sequence.add(toAdd.getModelComponent());
		return true;
	}

	@Override
	public boolean addTextInput(Property... properties) {
		return addTextInput("", false, properties);		
	}

	@Override
	public boolean addTextInput(String content, Property... properties) {
		return addTextInput("", false, properties);		
	}

	@Override
	public boolean addTextInput(String content, boolean isReadOnly,	Property... properties) {
		TextInput toAdd = new TextInput(content, isReadOnly);
		toAdd.setProperties((properties != null) ? Arrays.asList(properties) : new ArrayList<Property>());
		children.add(toAdd);
		sequence.add(toAdd.getModelComponent());
		return true;
	}

	@Override
	public boolean addAttributeComponent(String attrName, ArrayList<Box> values, boolean allowMultiselection) {
		BoxesArea toAdd = new BoxesArea(attrName, values, allowMultiselection);
		sequence.add(toAdd.getModelComponent());
		children.add(toAdd);
		return true;
	}
	
	@Override
	public boolean addAttributeComponent(String attrName, ArrayList<Box> values, boolean allowMultiselection, Property... properties) {
		BoxesArea toAdd = new BoxesArea(attrName, values, allowMultiselection);
		toAdd.setProperties((properties != null) ? Arrays.asList(properties) : new ArrayList<Property>());
		sequence.add(toAdd.getModelComponent());
		children.add(toAdd);
		return true;
	}
	
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addReference(ReferenceReport ref) {	
		sequence.add(ref.getModelComponent());
		children.add(ref);
		return true;
	}

	/** (non-Javadoc)
	 * @see org.gcube.application.reporting.Sequentiable#addInstruction(java.lang.String)
	 */
	@Override
	public boolean addInstruction(String content) {
		sequence.add(new Instruction(content).getModelComponent());		
		return true;
	}

	public List<BasicComponent> getSequence() {
		return sequence;
	}

	@Override
	public ReportComponentType getType() {
		return ReportComponentType.SEQUENCE;
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public List<ReportComponent> getChildren() {
		return children;
	}

	@Override
	public String getStringValue() {
		return null;
	}

	@Override
	public BasicComponent getModelComponent() {
		ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
		//need to add the delimiters at begin / end
		groupedComponents.add(getSequenceDelimiter(15));
		for (BasicComponent elem : getSequence()) {
			groupedComponents.add(elem);
		}
		groupedComponents.add(getSequenceDelimiter(15));
		
		RepeatableSequence toEmbed = new RepeatableSequence(groupedComponents, getId(), 0);
		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.REPEAT_SEQUENCE, "", toEmbed, false, true, convertProperties());	
	}
	
	private BasicComponent getSequenceDelimiter(int height) {
		return new BasicComponent(0, 0, COMP_WIDTH, height, 
				1, ComponentType.REPEAT_SEQUENCE_DELIMITER, "", "", false, false, new ArrayList<Metadata>());	
	}
}
