/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import org.bson.Document;
import org.bson.types.ObjectId;

public class Serialization {
    public static final DateTimeFormatter FULL_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMdd_HH-mm-ss");
    public static ObjectMapper mapper = new ObjectMapper();

    public static <T> T read(String jsonString, Class<T> clazz) throws JsonProcessingException, IOException {
        return (T)mapper.readerFor(clazz).readValue(jsonString);
    }

    public static <T> Iterator<T> readCollection(String jsonString, Class<T> clazz) throws IOException {
        return mapper.readerFor(clazz).readValues(jsonString);
    }

    public static <T> Iterator<T> readCollection(InputStream is, Class<T> clazz) throws IOException {
        return mapper.readerFor(clazz).readValues(is);
    }

    public static String write(Object toWrite) throws JsonProcessingException {
        String toReturn = mapper.writeValueAsString(toWrite);
        return toReturn;
    }

    public static final <T> T convert(Object d, Class<T> clazz) {
        return (T)mapper.convertValue(d, clazz);
    }

    public static final Document asDocument(Object obj) throws JsonProcessingException {
        return Document.parse((String)mapper.writeValueAsString(obj));
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.registerModule((Module)new JavaTimeModule());
        SimpleModule s = new SimpleModule();
        s.addDeserializer(ObjectId.class, (JsonDeserializer)new ObjectIdDeserializer());
        s.addSerializer(ObjectId.class, (JsonSerializer)new ObjectIdSerializer());
        s.addDeserializer(Semver.class, (JsonDeserializer)new SemverDeserializer());
        s.addSerializer(Semver.class, (JsonSerializer)new SemverSerializer());
        mapper.registerModule((Module)s);
    }

    private static class SemverDeserializer
    extends JsonDeserializer<Semver> {
        private SemverDeserializer() {
        }

        public Semver deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            if (value == null || value.isEmpty() || value.equals("null")) {
                return null;
            }
            return new Semver(value);
        }

        public Class<Semver> handledType() {
            return Semver.class;
        }
    }

    private static class SemverSerializer
    extends JsonSerializer<Semver> {
        private SemverSerializer() {
        }

        public void serialize(Semver semver, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (semver == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(semver.getValue());
            }
        }

        public Class<Semver> handledType() {
            return Semver.class;
        }
    }

    private static class ObjectIdDeserializer
    extends JsonDeserializer<ObjectId> {
        private ObjectIdDeserializer() {
        }

        public ObjectId deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            if (value == null || value.isEmpty() || value.equals("null")) {
                return null;
            }
            return new ObjectId(value);
        }

        public Class<ObjectId> handledType() {
            return ObjectId.class;
        }
    }

    private static class ObjectIdSerializer
    extends JsonSerializer<ObjectId> {
        private ObjectIdSerializer() {
        }

        public void serialize(ObjectId objectId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (objectId == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(objectId.toString());
            }
        }

        public Class<ObjectId> handledType() {
            return ObjectId.class;
        }
    }
}

