/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model.profile;

import java.util.List;
import javax.json.JsonObject;
import org.gcube.application.geoportal.common.faults.JsonParseException;
import org.gcube.application.geoportal.common.model.BasicJSONObject;
import org.gcube.application.geoportal.common.model.profile.DefaultCompiler;
import org.gcube.application.geoportal.common.model.profile.Field;
import org.gcube.application.geoportal.common.model.profile.FieldMapping;
import org.gcube.application.geoportal.common.model.profile.IndexDefinition;
import org.gcube.application.geoportal.common.model.profile.IsoMapper;
import org.gcube.application.geoportal.common.model.profile.Serialization;
import org.gcube.application.geoportal.common.model.profile.Validator;

public class Profile
extends BasicJSONObject {
    private String name;
    private String id;
    private List<Field> fields;
    private List<DefaultCompiler> defaultCompilers;
    private List<Validator> validators;
    private IsoMapper isoMapper;
    private List<FieldMapping> centroidsMapping;
    private List<IndexDefinition> indexes;

    public Profile(JsonObject theObject) throws JsonParseException {
        super(theObject);
        this.name = theObject.getString("name");
        this.id = theObject.getString("_id");
        this.fields = Serialization.asArray(theObject.getJsonArray("fields"), Field.class);
        this.defaultCompilers = Serialization.asArray(theObject.getJsonArray("default_compilers"), DefaultCompiler.class);
        this.validators = Serialization.asArray(theObject.getJsonArray("validators"), Validator.class);
        this.isoMapper = new IsoMapper(theObject.getJsonObject("iso_mapper"));
        this.centroidsMapping = Serialization.asArray(theObject.getJsonArray("centroid_mapping"), FieldMapping.class);
        this.indexes = Serialization.asArray(theObject.getJsonArray("findexes"), IndexDefinition.class);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<DefaultCompiler> getDefaultCompilers() {
        return this.defaultCompilers;
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public IsoMapper getIsoMapper() {
        return this.isoMapper;
    }

    public List<FieldMapping> getCentroidsMapping() {
        return this.centroidsMapping;
    }

    public List<IndexDefinition> getIndexes() {
        return this.indexes;
    }

    public Profile() {
    }
}

