package org.gcube.application.geoportalcommon.shared;

import java.io.Serializable;


/**
 * The Class GeoNaItemRef.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 * Dec 1, 2020
 */
public class GeoNaItemRef implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7021431511279022193L;

	private Long itemId;
	private String itemType;
	private String itemName;

	private PublicLink restrictedLink;
	private PublicLink openLink;

	/**
	 * Instantiates a new geo na object.
	 */
	public GeoNaItemRef() {

	}

	/**
	 * Instantiates a new geo na object.
	 *
	 * @param itemId   the item id
	 * @param itemType the item type
	 */
	public GeoNaItemRef(Long itemId, String itemType) {
		super();
		this.itemId = itemId;
		this.itemType = itemType;
	}

	/**
	 * Gets the item id.
	 *
	 * @return the item id
	 */
	public Long getItemId() {
		return itemId;
	}

	/**
	 * Sets the item id.
	 *
	 * @param itemId the new item id
	 */
	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	/**
	 * Gets the item type.
	 *
	 * @return the item type
	 */
	public String getItemType() {
		return itemType;
	}

	/**
	 * Sets the item type.
	 *
	 * @param itemType the new item type
	 */
	public void setItemType(String itemType) {
		this.itemType = itemType;
	}

	/**
	 * Gets the item name.
	 *
	 * @return the item name
	 */
	public String getItemName() {
		return itemName;
	}

	/**
	 * Sets the item name.
	 *
	 * @param itemName the new item name
	 */
	public void setItemName(String itemName) {
		this.itemName = itemName;
	}
	
	

	/**
	 * Gets the restricted link.
	 *
	 * @return the restricted link
	 */
	public PublicLink getRestrictedLink() {
		return restrictedLink;
	}

	/**
	 * Sets the restricted link.
	 *
	 * @param restrictedLink the new restricted link
	 */
	public void setRestrictedLink(PublicLink restrictedLink) {
		this.restrictedLink = restrictedLink;
	}

	/**
	 * Gets the open link.
	 *
	 * @return the open link
	 */
	public PublicLink getOpenLink() {
		return openLink;
	}

	/**
	 * Sets the open link.
	 *
	 * @param openLink the new open link
	 */
	public void setOpenLink(PublicLink openLink) {
		this.openLink = openLink;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("GeoNaItemRef [itemId=");
		builder.append(itemId);
		builder.append(", itemType=");
		builder.append(itemType);
		builder.append(", itemName=");
		builder.append(itemName);
		builder.append(", restrictedLink=");
		builder.append(restrictedLink);
		builder.append(", openLink=");
		builder.append(openLink);
		builder.append("]");
		return builder.toString();
	}

	

}
