package org.gcube.application.geoportalcommon.shared.config;


/**
 * The Enum OPERATION_ON_ITEM.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 * Sep 13, 2022
 */
public enum OPERATION_ON_ITEM {

	CREATE_NEW_PROJECT("Create New Project"),
	VIEW_ON_MAP("View on Map"), 
	SHOW_METADATA("Show Metadata"), 
	VIEW_REPORT("View the Report"),
	EDIT_PROJECT("Edit the Project"), 
	CLONE_PROJECT("Clone the Project"),
	PUBLISH_UNPUBLISH_PROJECT("Publish/UnPublish the Project"),
	DELETE_PROJECT("Delete the Project"),
	CREATE_RELATION("Create Relation between two Projects"),
	VIEW_RELATIONSHIPS("View the relationship/s created for the Project");
	
	String label;
	
	/**
	 * Instantiates a new operation on item.
	 *
	 * @param label the label
	 */
	OPERATION_ON_ITEM(String label){
		this.label = label;
	}
	
	/**
	 * Gets the label.
	 *
	 * @return the label
	 */
	public String getLabel() {
		return label;
	}

}
