/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.report;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.geoportal.model.report.Check;
import org.gcube.application.geoportal.model.report.ConstraintCheck;
import org.gcube.application.geoportal.utils.Serialization;

public class ValidationReport
implements Serializable {
    private String objectName;
    private List<String> errorMessages = new ArrayList<String>();
    private List<String> warningMessages = new ArrayList<String>();
    private List<ValidationReport> children = new ArrayList<ValidationReport>();

    public ValidationStatus getStatus() {
        if (!this.errorMessages.isEmpty()) {
            return ValidationStatus.ERROR;
        }
        boolean isWarning = !this.warningMessages.isEmpty();
        for (ValidationReport obj : this.children) {
            ValidationStatus status = obj.getStatus();
            if (status.equals((Object)ValidationStatus.ERROR)) {
                return ValidationStatus.ERROR;
            }
            if (!status.equals((Object)ValidationStatus.WARNING)) continue;
            isWarning = true;
        }
        if (isWarning) {
            return ValidationStatus.WARNING;
        }
        return ValidationStatus.PASSED;
    }

    public void addChild(ValidationReport obj) {
        this.children.add(obj);
    }

    public void addMessage(ValidationStatus status, String message) {
        switch (status) {
            case ERROR: {
                this.errorMessages.add(message);
                break;
            }
            case WARNING: {
                this.warningMessages.add(message);
            }
        }
    }

    public <T> boolean checkMandatory(T toCheck, String name, Check ... checks) {
        ConstraintCheck<T> check = new ConstraintCheck<T>(toCheck, name, checks);
        if (check.isError()) {
            this.addMessage(ValidationStatus.ERROR, check.getMessage());
        }
        return !check.isError();
    }

    public ValidationReport(String objectName) {
        this.objectName = objectName;
    }

    public String prettyPrint() throws JsonProcessingException {
        return Serialization.prettyPrint(this);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public List<ValidationReport> getChildren() {
        return this.children;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public void setWarningMessages(List<String> warningMessages) {
        this.warningMessages = warningMessages;
    }

    public void setChildren(List<ValidationReport> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationReport)) {
            return false;
        }
        ValidationReport other = (ValidationReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$objectName = this.getObjectName();
        String other$objectName = other.getObjectName();
        if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
            return false;
        }
        List<String> this$errorMessages = this.getErrorMessages();
        List<String> other$errorMessages = other.getErrorMessages();
        if (this$errorMessages == null ? other$errorMessages != null : !((Object)this$errorMessages).equals(other$errorMessages)) {
            return false;
        }
        List<String> this$warningMessages = this.getWarningMessages();
        List<String> other$warningMessages = other.getWarningMessages();
        if (this$warningMessages == null ? other$warningMessages != null : !((Object)this$warningMessages).equals(other$warningMessages)) {
            return false;
        }
        List<ValidationReport> this$children = this.getChildren();
        List<ValidationReport> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $objectName = this.getObjectName();
        result = result * 59 + ($objectName == null ? 0 : $objectName.hashCode());
        List<String> $errorMessages = this.getErrorMessages();
        result = result * 59 + ($errorMessages == null ? 0 : ((Object)$errorMessages).hashCode());
        List<String> $warningMessages = this.getWarningMessages();
        result = result * 59 + ($warningMessages == null ? 0 : ((Object)$warningMessages).hashCode());
        List<ValidationReport> $children = this.getChildren();
        result = result * 59 + ($children == null ? 0 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationReport(objectName=" + this.getObjectName() + ", errorMessages=" + this.getErrorMessages() + ", warningMessages=" + this.getWarningMessages() + ", children=" + this.getChildren() + ")";
    }

    public static enum ValidationStatus {
        PASSED,
        ERROR,
        WARNING;

    }
}

