/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers;

import java.util.List;
import java.util.Map;
import org.gcube.application.cms.caches.AbstractScopedMap;
import org.gcube.application.cms.implementations.ISInterface;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.geoportal.common.model.configuration.MongoConnection;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.service.model.internal.db.Mongo;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MongoClientProvider
extends AbstractScopedMap<Mongo> {
    private static final Logger log = LoggerFactory.getLogger(MongoClientProvider.class);

    public MongoClientProvider() {
        super("MongoClient cache");
    }

    protected Mongo retrieveObject(String context) throws ConfigurationException {
        MongoConnection conn = MongoClientProvider.performQueryForMongoDB((ISInterface)((ISInterface)ImplementationProvider.get().getProvidedObjectByClass(ISInterface.class)), (String)"Database", (String)"mongodb", (String)"GNA_DB", (String)"internal-db");
        log.debug("Connecting to " + conn);
        return new Mongo(conn);
    }

    protected void dispose(Mongo toDispose) {
        toDispose.close();
    }

    private static MongoConnection performQueryForMongoDB(ISInterface is, String category, String platform, String flagName, String flagValue) throws ConfigurationException {
        List found = is.performGetAP(category, platform, flagName, flagValue);
        if (found.size() > 1) {
            throw new ConfigurationException("Multiple SE found [" + found.size() + "] for platform : " + platform + " flag : " + flagValue);
        }
        if (found.isEmpty()) {
            throw new ConfigurationException("No SE found for platform : " + platform + " flag : " + flagValue);
        }
        ServiceEndpoint.AccessPoint point = (ServiceEndpoint.AccessPoint)found.get(0);
        MongoConnection toReturn = new MongoConnection();
        for (ServiceEndpoint.Property prop : point.properties()) {
            switch (prop.name()) {
                case "host": {
                    toReturn.getHosts().add(prop.value());
                }
            }
        }
        toReturn.getHosts().add(point.address());
        Map props = point.propertyMap();
        toReturn.setDatabase(((ServiceEndpoint.Property)props.get("database")).value());
        toReturn.setPassword(is.decryptString(point.password()));
        toReturn.setPort(Integer.parseInt(((ServiceEndpoint.Property)props.get("port")).value()));
        toReturn.setUser(point.username());
        return toReturn;
    }
}

