/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import org.gcube.application.geoportal.service.engine.providers.AbstractScopedMap;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.application.geoportal.service.utils.ContextUtils;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.transfer.library.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClientProvider
extends AbstractScopedMap<IClient> {
    private static final Logger log = LoggerFactory.getLogger(StorageClientProvider.class);

    public StorageClientProvider() {
        super("Storage client cache");
        this.setTTL((TemporalAmount)Duration.of(10L, ChronoUnit.MINUTES));
    }

    protected IClient retrieveObject() throws ConfigurationException {
        return new StorageClient("Application", "GeoPortal", ContextUtils.getCurrentCaller(), AccessType.SHARED, MemoryType.VOLATILE).getClient();
    }

    protected void dispose(IClient toDispose) {
    }

    public void init() {
    }

    public InputStream open(String id) throws MalformedURLException, RemoteBackendException, IOException, ConfigurationException {
        return new URL(((IClient)this.getObject()).getHttpsUrl().RFileById(id)).openConnection().getInputStream();
    }

    public String store(InputStream is) throws RemoteBackendException, ConfigurationException {
        return ((IClient)this.getObject()).put(true).LFile(is).RFile(Utils.getUniqueString());
    }
}

