/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.mongo;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Sorts;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.service.model.internal.db.Mongo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoManager {
    private static final Logger log = LoggerFactory.getLogger(MongoManager.class);
    protected Mongo client = (Mongo)ImplementationProvider.get().getProvidedObjectByClass(Mongo.class);
    protected MongoCollection<Document> collection = null;
    protected static final String ID = "_id";

    protected static final ObjectId asId(String id) {
        return new ObjectId(id);
    }

    protected static final String asString(ObjectId id) {
        return id.toHexString();
    }

    protected static final String asString(Document d) {
        return d.toJson();
    }

    protected static final Document asDoc(String json) {
        return Document.parse((String)json);
    }

    public MongoManager() throws ConfigurationException {
        log.trace("Cached client is  {} ", (Object)this.client);
    }

    protected void init(String collectionName) {
        String toUseDB = this.client.getConnection().getDatabase();
        log.info("Opening collection {} : {} ", (Object)toUseDB, (Object)collectionName);
        this.collection = this.client.getTheClient().getDatabase(toUseDB).getCollection(collectionName);
    }

    MongoCollection getCollection() {
        return this.collection;
    }

    protected abstract String mongoIDFieldName();

    protected ObjectId insertDoc(Document proj) {
        MongoCollection collection = this.getCollection();
        ObjectId id = proj.getObjectId((Object)this.mongoIDFieldName());
        if (id == null) {
            proj.append(this.mongoIDFieldName(), (Object)new ObjectId());
            id = proj.getObjectId((Object)this.mongoIDFieldName());
        }
        collection.insertOne((Object)Document.parse((String)proj.toJson()));
        return id;
    }

    public void deleteDoc(ObjectId id) {
        MongoCollection collection = this.getCollection();
        collection.deleteOne(Filters.eq((String)this.mongoIDFieldName(), (Object)id));
    }

    public Document getDocById(ObjectId id, Document additionalFilter) {
        MongoCollection coll = this.getCollection();
        Document condition = new Document(this.mongoIDFieldName(), (Object)id);
        if (additionalFilter != null) {
            condition.putAll((Map)additionalFilter);
        }
        return (Document)coll.find((Bson)condition).first();
    }

    public Document getDocById(ObjectId id) {
        return this.getDocById(id, null);
    }

    public FindIterable<Document> iterateDoc(Document filter, Document projection) {
        MongoCollection coll = this.getCollection();
        if (filter == null) {
            filter = new Document();
        }
        log.trace("Applying Filter " + filter.toJson());
        if (projection != null) {
            log.trace("Applying projection " + projection.toJson());
            return coll.find((Bson)filter).projection((Bson)projection);
        }
        return coll.find((Bson)filter);
    }

    public FindIterable<Document> queryDoc(QueryRequest request) {
        FindIterable toReturn = this.iterateDoc(request.getFilter(), request.getProjection());
        if (request.getOrdering() != null) {
            toReturn = request.getOrdering().getDirection().equals((Object)QueryRequest.OrderedRequest.Direction.ASCENDING) ? toReturn.sort(Sorts.ascending((List)request.getOrdering().getFields())) : toReturn.sort(Sorts.descending((List)request.getOrdering().getFields()));
        }
        if (request.getPaging() != null) {
            QueryRequest.PagedRequest paging = request.getPaging();
            toReturn = toReturn.skip(paging.getOffset()).limit(paging.getLimit());
        }
        return toReturn;
    }

    public Document replaceDoc(Document toUpdate, ObjectId id) {
        MongoCollection coll = this.getCollection();
        return (Document)coll.findOneAndReplace(Filters.eq((String)this.mongoIDFieldName(), (Object)id), (Object)toUpdate, new FindOneAndReplaceOptions().returnDocument(ReturnDocument.AFTER));
    }

    public Document updateDoc(ObjectId id, Document updateSet) {
        MongoCollection coll = this.getCollection();
        return (Document)coll.findOneAndUpdate(Filters.eq((String)this.mongoIDFieldName(), (Object)id), (Bson)updateSet, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
    }
}

