package org.gcube.application.geoportal.service.engine.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.extern.slf4j.Slf4j;
import org.gcube.application.geoportal.common.model.profile.Profile;
import org.gcube.application.geoportal.common.utils.Files;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.application.geoportal.service.utils.Serialization;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

@Slf4j
public class ProfileMapCache extends AbstractScopedMap<Map<String,Profile>> {

	public ProfileMapCache() {
		super("Profiles CACHE");

	}

	@Override
	public void init() {

	}

	@Override
	protected void dispose(Map<String, Profile> toDispose) {

	}
	
	@Override
	protected Map<String, Profile> retrieveObject() throws ConfigurationException {


		// Load from resources
		HashMap<String,Profile> toReturn=new HashMap<>();

		try {
			Profile p=Serialization.read(Files.
					readFileAsString(Files.getFileFromResources("profiles/profiledConcessioni.json").getAbsolutePath(), Charset.defaultCharset()), Profile.class);
			log.debug("Loaded "+p.getName()+" ID "+p.getId());
			toReturn.put(p.getId(),p);


		}catch (JsonProcessingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return toReturn;

	}

}
