/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.gcube.application.cms.plugins.InitializablePlugin;
import org.gcube.application.cms.plugins.Plugin;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.geoportal.common.utils.ContextUtils;
import org.gcube.application.geoportal.service.engine.providers.AbstractScopedMap;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager
extends AbstractScopedMap<Map<String, Plugin>> {
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    Map<String, Plugin> implementations = new HashMap();

    public PluginManager() {
        super("Plugin Cache");
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackage("org.gcube.application.cms", new ClassLoader[0]).filterInputsBy((Predicate)new FilterBuilder().includePackage("org.gcube.application.cms")));
        reflections.getSubTypesOf(Plugin.class).iterator().forEachRemaining(pluginClass -> {
            if (!pluginClass.isInterface()) {
                try {
                    Plugin plugin = (Plugin)pluginClass.newInstance();
                    log.debug("Loading {} descriptiorn : ", (Object)plugin, (Object)plugin.getDescriptor());
                    this.implementations.put(plugin.getDescriptor().getId(), plugin);
                }
                catch (Throwable t) {
                    log.warn("Unable to instantiate Plugin " + pluginClass, t);
                }
            }
        });
        log.info("Loaded {} plugins", (Object)this.implementations.keySet().size());
        this.implementations.forEach((id, p) -> {
            if (p instanceof InitializablePlugin) {
                log.info("INIT Plugin {}", id);
                try {
                    InitializablePlugin ip = (InitializablePlugin)p;
                    InitializationReport rep = ip.init();
                    log.info("INIT REPORT : {}", (Object)rep);
                }
                catch (InitializationException e) {
                    log.error("Failed to initialize " + id, (Throwable)e);
                }
                catch (Throwable t) {
                    log.error("Unable to initialize " + id, t);
                }
            }
        });
    }

    protected Map<String, Plugin> retrieveObject() throws ConfigurationException {
        this.implementations.forEach((id, p) -> {
            if (p instanceof InitializablePlugin) {
                log.info("INIT Plugin {} in context {} ", id, (Object)ContextUtils.getCurrentScope());
                try {
                    InitializablePlugin ip = (InitializablePlugin)p;
                    InitializationReport rep = ip.initInContext();
                    log.info("INIT REPORT : {}", (Object)rep);
                }
                catch (InitializationException e) {
                    log.error("Failed to initialize " + id, (Throwable)e);
                }
                catch (Throwable t) {
                    log.error("Unable to initialize " + id, t);
                }
            }
        });
        return this.implementations;
    }

    protected void dispose(Map<String, Plugin> toDispose) {
        this.implementations.forEach((id, p) -> {
            if (p instanceof InitializablePlugin) {
                log.info("Shutting down Plugin {}", id);
                try {
                    InitializablePlugin ip = (InitializablePlugin)p;
                    ip.shutdown();
                }
                catch (ShutDownException e) {
                    log.error("Failed to shutdown " + id, (Throwable)e);
                }
                catch (Throwable t) {
                    log.error("Unable to shutdown " + id, t);
                }
            }
        });
    }

    public void init() {
    }
}

