/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import com.j256.ormlite.dao.CloseableIterator;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.gcube.application.aquamaps.images.model.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor
extends HttpServlet {
    private static final XStream xStream = new XStream();
    private static final long serialVersionUID = 2486605867155769417L;
    private static final Logger logger;

    static {
        xStream.processAnnotations(Statistics.class);
        logger = LoggerFactory.getLogger(Monitor.class);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block17: {
            CloseableIterator it = null;
            resp.setContentType("application/xml");
            try {
                try {
                    Common com = Common.get();
                    it = com.getDao().closeableIterator();
                    long speciesCount = 0L;
                    long pictureCount = 0L;
                    long nativeCount = 0L;
                    long native2050Count = 0L;
                    long suitableCount = 0L;
                    long suitable2050Count = 0L;
                    while (it.hasNext()) {
                        SpeciesInfo spec = (SpeciesInfo)it.next();
                        ++speciesCount;
                        if (spec.getPic() != null) {
                            ++pictureCount;
                        }
                        if (spec.getNativeURI() != null) {
                            ++nativeCount;
                        }
                        if (spec.getNative2050URI() != null) {
                            ++native2050Count;
                        }
                        if (spec.getSuitableURI() != null) {
                            ++suitableCount;
                        }
                        if (spec.getSuitable2050URI() == null) continue;
                        ++suitable2050Count;
                    }
                    PrintWriter writer = resp.getWriter();
                    writer.write(xStream.toXML((Object)new Statistics(speciesCount, pictureCount, nativeCount, native2050Count, suitableCount, suitable2050Count, com.getLastCompletedUpdate().longValue())));
                    writer.flush();
                }
                catch (Exception e) {
                    logger.error("Unexpected Error ", (Throwable)e);
                    resp.setStatus(500);
                    if (it == null) break block17;
                    try {
                        it.close();
                    }
                    catch (Exception e2) {
                        logger.error("Unable to close iterator ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (it != null) {
                    try {
                        it.close();
                    }
                    catch (Exception e) {
                        logger.error("Unable to close iterator ", (Throwable)e);
                    }
                }
            }
        }
    }
}

