/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.consumers;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.speciesmanager.context.ServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class RuntimeResourceConsumer
extends ISNotifier.BaseNotificationConsumer {
    private static GCUBELog logger = new GCUBELog(RuntimeResourceConsumer.class);
    private static List<GCUBEScope> scopes = new ArrayList<GCUBEScope>();
    private static RuntimeResourceConsumer cache = new RuntimeResourceConsumer();

    private RuntimeResourceConsumer() {
    }

    public static RuntimeResourceConsumer getConsumer(GCUBEScope scope) {
        if (!scopes.contains(scope)) {
            scopes.add(scope);
        }
        return cache;
    }

    public static void releaseConsumer(GCUBEScope scope) {
        scopes.remove(scope);
    }

    protected synchronized void onNotificationReceived(ISNotifier.NotificationEvent event) {
        try {
            String id = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
            String operation = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
            String scopeNotifyed = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(4).getChildNodes().item(0).getNodeValue();
            GCUBEScope notificationScope = GCUBEScope.getScope((String)scopeNotifyed);
            logger.info((Object)("notification received for runtimeResource " + id + " and operation " + operation + "," + scopeNotifyed));
            if (operation.equals("destroy")) {
                for (GCUBEScope scope : scopes) {
                    if (!scope.equals((Object)scopeNotifyed) && !scope.isEnclosedIn(GCUBEScope.getScope((String)scopeNotifyed))) continue;
                    ServiceContext.getContext().removePlugin(scope);
                }
            } else {
                GCUBERuntimeResource runtimeResource = (GCUBERuntimeResource)GHNContext.getImplementation(GCUBERuntimeResource.class);
                String profile = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
                runtimeResource.load((Reader)new StringReader(profile));
                for (GCUBEScope rrscope : runtimeResource.getScopes().values()) {
                    logger.trace((Object)("scope in " + runtimeResource.getID() + " is " + rrscope));
                }
                if (operation.equals("update")) {
                    ServiceContext.getContext().updatePlugin(runtimeResource, notificationScope);
                } else if (operation.equals("create")) {
                    ServiceContext.getContext().activatePlugin(runtimeResource, notificationScope);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error managing notification", (Throwable)e);
        }
    }
}

