/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.util;

import java.io.Serializable;
import java.net.URI;
import java.rmi.Remote;
import java.util.Random;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.contentmanagement.cache.factories.NewContentInfoCacheEntryFactory;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.cache.factories.ApplicationCredentials;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.exceptions.UnknownDocumentException;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.service.DataTransformationServiceAddressingLocator;
import org.gcube.informationsystem.cache.SrvType;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThumbnailUtils.class);
    public static final int chunkSize = 0x100000;

    public static byte[] getContentFromCMS(String oid, String scope) throws Exception {
        URI contentURI = new URI(oid);
        String collectionId = URIs.collectionID((URI)contentURI);
        String contentId = URIs.documentID((URI)contentURI);
        DocumentReader reader = null;
        GCubeDocument doc = null;
        try {
            reader = new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            doc = reader.get(contentId, (Projection)Projections.document().with(Projections.opt((Property)Projections.BYTESTREAM), (Property[])new PropertyTypes.DocumentProperty[0]));
        }
        catch (UnknownDocumentException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (ManagerCall.DiscoveryException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (GCUBEException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (doc.bytestream() != null) {
            byte[] bytes = doc.bytestream();
            return bytes;
        }
        return null;
    }

    public static String getMimeType(String oid, String scope) throws Exception {
        URI uri = new URI(oid);
        String collectionId = URIs.collectionID((URI)uri);
        String documentId = URIs.documentID((URI)uri);
        try {
            QueryString query = new QueryString();
            query.addParameter("vre", scope);
            query.addParameter("oid", oid);
            query.addParameter("cid", collectionId);
            GCubeDocument docDescription = (GCubeDocument)CachesManager.getInstance().getEhcache("newContent", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
            return docDescription.mimeType();
        }
        catch (Exception e) {
            logger.info("An error occured while trying to retrieve document's mime type from cache");
            return "unknown/unknown";
        }
    }

    public static DataTransformationServicePortType getDTSPortType(String scope) throws Exception {
        Object result = null;
        EndpointReference[] dtsURIs = null;
        try {
            dtsURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        Random random = new Random();
        String dtsAddress = dtsURIs[random.nextInt(dtsURIs.length)].getAddress().toString();
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress((AttributedURI)new Address(dtsAddress));
        DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
        DataTransformationServicePortType dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
        try {
            dts = (DataTransformationServicePortType)ServiceContextManager.applySecurity((Remote)dts, (GCUBEScope)GCUBEScope.getScope((String)scope), (GSSCredential)ApplicationCredentials.getInstance().getCredential(scope));
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        return dts;
    }

    public static GCubeDocument getDocumentDescription(String oid, String scope) throws Exception {
        QueryString newQuery = new QueryString();
        newQuery.addParameter("vre", scope);
        newQuery.addParameter("oid", oid);
        GCubeDocument docDescription = (GCubeDocument)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)newQuery).getValue();
        return docDescription;
    }
}

